/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DefaultAssigneeService
implements AssigneeService {
    private final PermissionContextFactory permissionContextFactory;
    private final PermissionSchemeManager permissionSchemeManager;
    private final UserManager userManager;
    private final UserHistoryManager userHistoryManager;
    private ChangeHistoryManager changeHistoryManager;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultAssigneeService(PermissionContextFactory permissionContextFactory, PermissionSchemeManager permissionSchemeManager, UserManager userManager, UserHistoryManager userHistoryManager, FeatureManager featureManager, JiraAuthenticationContext authenticationContext) {
        this.permissionContextFactory = permissionContextFactory;
        this.permissionSchemeManager = permissionSchemeManager;
        this.userManager = userManager;
        this.userHistoryManager = userHistoryManager;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
    }

    public List<User> getSuggestedAssignees(Issue issue, @Nullable User loggedInUser, @Nullable ActionDescriptor actionDescriptor) {
        List<User> assignableUsers = new AssignableUsers(issue, actionDescriptor).findAll();
        List<User> suggestedAssignees = this.getSuggestedAssignees(issue, loggedInUser, assignableUsers);
        Collections.sort(suggestedAssignees, new UserBestNameComparator(this.authenticationContext.getLocale()));
        return suggestedAssignees;
    }

    public List<User> getSuggestedAssignees(Issue issue, User loggedInUser, List<User> assignableUsers) {
        Set<String> suggestedAssigneeNames = this.getSuggestedAssigneeNames(issue, loggedInUser);
        return this.getSuggestedAssignees(suggestedAssigneeNames, assignableUsers);
    }

    public Collection<User> findAssignableUsers(String query, Issue issue, @Nullable ActionDescriptor actionDescriptor) {
        return new AssignableUsers(issue, actionDescriptor).matchingUsername(query).findAllAndSort();
    }

    public Collection<User> findAssignableUsers(String query, Project project) {
        return new AssignableUsers(project).matchingUsername(query).findAllAndSort();
    }

    private List<User> findAssignableUsers(String query, Collection<User> assignableUsers) {
        String convertedQuery;
        ArrayList<User> returnUsers = new ArrayList();
        String string = convertedQuery = query == null ? "" : query.trim().toLowerCase();
        if (StringUtils.isNotBlank((String)query)) {
            UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, true);
            for (User user : assignableUsers) {
                if (!userMatcher.apply(user)) continue;
                returnUsers.add(user);
            }
        } else {
            returnUsers = new ArrayList<User>(assignableUsers);
        }
        return returnUsers;
    }

    private Set<String> getSuggestedAssigneeNames(Issue issue, User loggedInUser) {
        HashSet<String> suggestedAssignees = new HashSet<String>();
        if (loggedInUser != null && this.useFrotherControl()) {
            suggestedAssignees.add(loggedInUser.getName());
        }
        suggestedAssignees.addAll(this.getRecentAssigneeNamesForIssue(issue));
        suggestedAssignees.addAll(this.getRecentAssigneeNamesForUser(loggedInUser));
        User reporter = issue.getReporter();
        if (reporter != null) {
            suggestedAssignees.add(reporter.getName());
        }
        return suggestedAssignees;
    }

    private boolean useFrotherControl() {
        boolean on = this.featureManager.isEnabled("frother.assignee.field");
        boolean off = this.featureManager.isEnabled("no.frother.assignee.field");
        return on && !off;
    }

    public List<User> getSuggestedAssignees(Set<String> suggestedAssigneeNames, List<User> assignableUsers) {
        ArrayList<User> suggestedAssignees = new ArrayList<User>();
        if (!suggestedAssigneeNames.isEmpty()) {
            for (User user : assignableUsers) {
                if (!suggestedAssigneeNames.remove(user.getName())) continue;
                suggestedAssignees.add(user);
            }
        }
        return suggestedAssignees;
    }

    public List<User> getAssignableUsers(Project project) {
        return new AssignableUsers(project).findAllAndSort();
    }

    public List<User> getAssignableUsers(Issue issue, ActionDescriptor actionDescriptor) {
        return new AssignableUsers(issue, actionDescriptor).findAllAndSort();
    }

    private Collection<User> getUniqueUsers(Collection<User> users) {
        HashMap<String, User> uniqueUsers = new HashMap<String, User>();
        Iterator<User> i$ = users.iterator();
        while (i$.hasNext()) {
            User user;
            User realUser = user = i$.next();
            if (uniqueUsers.containsKey(user.getName())) {
                realUser = this.userManager.getUser(user.getName());
            }
            uniqueUsers.put(user.getName(), realUser);
        }
        return uniqueUsers.values();
    }

    public Set<String> getRecentAssigneeNamesForIssue(Issue issue) {
        String assigneeId;
        HashSet<String> recentAssignees = new HashSet<String>();
        List assigneeHistory = this.getChangeHistoryManager().getChangeItemsForField(issue, "assignee");
        Collections.sort(assigneeHistory, new Comparator<ChangeItemBean>(){

            @Override
            public int compare(ChangeItemBean changeItemBean1, ChangeItemBean changeItemBean2) {
                return changeItemBean2.getCreated().compareTo(changeItemBean1.getCreated());
            }
        });
        for (ChangeItemBean changeItemBean : assigneeHistory) {
            recentAssignees.add(changeItemBean.getTo());
            if (recentAssignees.size() < 5) continue;
            break;
        }
        if ((assigneeId = issue.getAssigneeId()) != null) {
            recentAssignees.add(assigneeId);
        }
        return recentAssignees;
    }

    public Map<String, Boolean> makeUniqueFullNamesMap(Collection<User> users) {
        HashMap<String, Boolean> uniqueFullNames = new HashMap<String, Boolean>();
        for (User user : users) {
            String fullName = user.getDisplayName();
            Boolean isUnique = (Boolean)uniqueFullNames.get(fullName);
            if (isUnique == null) {
                uniqueFullNames.put(fullName, Boolean.TRUE);
                continue;
            }
            uniqueFullNames.put(fullName, Boolean.FALSE);
        }
        return uniqueFullNames;
    }

    public Set<String> getRecentAssigneeNamesForUser(User remoteUser) {
        ArrayList recentUserHistory = new ArrayList(this.userHistoryManager.getHistory(UserHistoryItem.ASSIGNEE, remoteUser));
        Collections.sort(recentUserHistory, new Comparator<UserHistoryItem>(){

            @Override
            public int compare(UserHistoryItem userHistoryItem1, UserHistoryItem userHistoryItem2) {
                return (int)(userHistoryItem2.getLastViewed() - userHistoryItem1.getLastViewed());
            }
        });
        HashSet<String> recentHistoryAssignees = new HashSet<String>();
        for (UserHistoryItem userHistoryItem : recentUserHistory) {
            recentHistoryAssignees.add(userHistoryItem.getEntityId());
            if (recentHistoryAssignees.size() < 5) continue;
            break;
        }
        return recentHistoryAssignees;
    }

    void setChangeHistoryManager(ChangeHistoryManager changeHistoryManager) {
        this.changeHistoryManager = changeHistoryManager;
    }

    private ChangeHistoryManager getChangeHistoryManager() {
        if (this.changeHistoryManager == null) {
            this.setChangeHistoryManager(ComponentAccessor.getChangeHistoryManager());
        }
        return this.changeHistoryManager;
    }

    final class AssignableUsers {
        private final Issue issue;
        private final PermissionContext ctx;
        private final String matchingUsername;

        AssignableUsers(Project project) {
            this.issue = null;
            this.ctx = DefaultAssigneeService.this.permissionContextFactory.getPermissionContext(project);
            this.matchingUsername = null;
        }

        AssignableUsers(Issue issue, ActionDescriptor actionDescriptor) {
            this.issue = issue;
            this.ctx = DefaultAssigneeService.this.permissionContextFactory.getPermissionContext(issue, actionDescriptor);
            this.matchingUsername = null;
        }

        AssignableUsers(Issue issue, PermissionContext ctx, String matchingUsername) {
            this.issue = issue;
            this.ctx = ctx;
            this.matchingUsername = matchingUsername;
        }

        public AssignableUsers matchingUsername(String matchingUsername) {
            return new AssignableUsers(this.issue, this.ctx, matchingUsername);
        }

        public List<User> findAll() {
            Collection users = DefaultAssigneeService.this.permissionSchemeManager.getUsers(Long.valueOf(17L), this.ctx);
            ArrayList assignableUsers = Lists.newArrayList((Iterable)DefaultAssigneeService.this.getUniqueUsers(users));
            if (this.issue != null && this.issue.getAssignee() != null && !assignableUsers.contains(this.issue.getAssignee())) {
                assignableUsers.add(this.issue.getAssignee());
            }
            if (this.matchingUsername != null) {
                assignableUsers.retainAll(DefaultAssigneeService.this.findAssignableUsers(this.matchingUsername, assignableUsers));
            }
            return Lists.newArrayList((Iterable)assignableUsers);
        }

        public List<User> findAllAndSort() {
            List<User> users = this.findAll();
            Collections.sort(users, new UserBestNameComparator(DefaultAssigneeService.this.authenticationContext.getLocale()));
            return users;
        }
    }
}

