/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public abstract class BaseFilterSubscriptionsCheck
extends CheckImpl {
    private static final Logger log = Logger.getLogger(BaseFilterSubscriptionsCheck.class);

    protected BaseFilterSubscriptionsCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    protected List doCheck(boolean correct) throws IntegrityException {
        ArrayList messages = new ArrayList();
        OfBizListIterator listIterator = null;
        try {
            listIterator = this.ofBizDelegator.findListIteratorByCondition("FilterSubscription", null);
            GenericValue subscription = listIterator.next();
            while (subscription != null) {
                this.doRealCheck(correct, subscription, messages);
                subscription = listIterator.next();
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        if (correct && !messages.isEmpty()) {
            for (DeleteEntityAmendment amendment : messages) {
                GenericValue subscriptionGV = amendment.getEntity();
                try {
                    ComponentAccessor.getSubscriptionManager().deleteSubscription(subscriptionGV.getLong("id"));
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to remove the subscription from the database", (Throwable)e);
                    throw new IntegrityException(e);
                }
            }
        }
        return messages;
    }

    protected abstract void doRealCheck(boolean var1, GenericValue var2, List var3) throws IntegrityException;
}

