/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less.inlineimage;

import com.atlassian.jira.web.less.LessTransformer;
import com.atlassian.jira.web.less.inlineimage.Base64ImageInputStreamEncoder;
import com.atlassian.jira.web.less.inlineimage.InlineImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class InlineImageEncoder {
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();
    public static ThreadLocal<LessTransformer.LessResource.BaseLoader> resourceLoader;

    public static InlineImage encode(String imagePath) {
        String mimeType = InlineImageEncoder.getImageType(imagePath);
        String data = "";
        try {
            InputStream imageInputStream = resourceLoader.get().getResourceInputStream(imagePath);
            if (imageInputStream == null) {
                return null;
            }
            data = Base64ImageInputStreamEncoder.encode(imageInputStream, mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new InlineImage(data, MIME_TYPES.get(mimeType));
    }

    public static String getImageType(String imagePath) {
        String suffix = imagePath.substring(imagePath.lastIndexOf(".") + 1);
        if (MIME_TYPES.containsKey(suffix)) {
            return suffix;
        }
        return "png";
    }

    public static LessTransformer.LessResource.BaseLoader getLoader() {
        return resourceLoader.get();
    }

    public static void setLoader(LessTransformer.LessResource.BaseLoader loader) {
        resourceLoader.set(loader);
    }

    static {
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("gif", "image/gif");
        resourceLoader = new ThreadLocal();
    }
}

