/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class EditCustomField
extends JiraWebActionSupport {
    private Long id;
    private String name;
    private String description;
    private String searcher;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldService customFieldService;
    private final ReindexMessageManager reindexMessageManager;

    public EditCustomField(CustomFieldService customFieldService, CustomFieldManager customFieldManager, ReindexMessageManager reindexMessageManager) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
    }

    public String doDefault() throws Exception {
        this.setName(this.getCustomField().getName());
        this.setDescription(this.getCustomField().getDescription());
        CustomFieldSearcher currentSearcher = this.getCurrentSearcher();
        this.setSearcher(currentSearcher != null ? currentSearcher.getDescriptor().getCompleteKey() : null);
        return "input";
    }

    protected void doValidation() {
        this.customFieldService.validateUpdate(this.getJiraServiceContext(), this.id, this.name, this.description, this.searcher);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        CustomField updatedField = this.getCustomField();
        updatedField.setName(this.getName());
        updatedField.setDescription(this.getDescription());
        CustomFieldSearcher oldSearcher = updatedField.getCustomFieldSearcher();
        if (ObjectUtils.isValueSelected((Object)this.searcher)) {
            CustomFieldSearcher newSearcher = this.customFieldManager.getCustomFieldSearcher(this.searcher);
            updatedField.setCustomFieldSearcher(newSearcher);
            if (oldSearcher == null || !oldSearcher.getDescriptor().getCompleteKey().equals(newSearcher.getDescriptor().getCompleteKey())) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.custom.fields");
            }
        } else {
            updatedField.setCustomFieldSearcher(null);
        }
        this.customFieldManager.updateCustomField(updatedField);
        return this.getRedirect("ViewCustomFields.jspa");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSearcher(String searcher) {
        this.searcher = searcher;
    }

    public String getSearcher() {
        return this.searcher;
    }

    public List getSearchers() {
        return this.customFieldManager.getCustomFieldSearchers(this.customFieldManager.getCustomFieldObject(this.getId()).getCustomFieldType());
    }

    public CustomFieldSearcher getCurrentSearcher() {
        return this.getCustomField().getCustomFieldSearcher();
    }

    public CustomField getCustomField() {
        return this.customFieldManager.getCustomFieldObject(this.getId());
    }
}

