/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;

public class JRA24857Check
implements SystemEnvironmentCheck {
    private static final Logger log = Logger.getLogger(JRA24857Check.class);
    private static final String ENGINE = "MyISAM";
    private final OfBizConnectionFactory factory;
    private final DelegatorInterface delegatorInterface;

    @VisibleForTesting
    JRA24857Check(OfBizConnectionFactory factory, DelegatorInterface delegatorInterface) {
        this.delegatorInterface = delegatorInterface;
        this.factory = (OfBizConnectionFactory)Preconditions.checkNotNull((Object)factory);
    }

    public JRA24857Check() {
        this(new DefaultOfBizConnectionFactory(), (DelegatorInterface)CoreFactory.getGenericDelegator());
    }

    public String getName() {
        return "MySQL MyISAM Check";
    }

    @Override
    public I18nMessage getWarningMessage() {
        Set<String> jiraTablesUsingMyISAM;
        if (this.isMySQL() && (!(jiraTablesUsingMyISAM = this.getJiraTablesUsingMyISAM()).isEmpty() || this.isSessionUsingMySIAM())) {
            return this.createWarning();
        }
        return null;
    }

    private Set<String> getJiraTablesUsingMyISAM() {
        Set<String> badTables = this.getMyISAMTables();
        badTables.retainAll(this.getJiraTables());
        return badTables;
    }

    @VisibleForTesting
    protected I18nMessage createWarning() {
        HelpUtil helpUtil = new HelpUtil();
        I18nMessage warning = new I18nMessage("admin.warning.JRA24857.syscheck");
        warning.setLink(helpUtil.getHelpPath("JRA24857").getUrl());
        return warning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isSessionUsingMySIAM() {
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block7: {
            connection = null;
            statement = null;
            resultSet = null;
            connection = this.factory.getConnection();
            statement = connection.createStatement(1003, 1007);
            resultSet = statement.executeQuery("SELECT @@storage_engine as engine");
            if (!resultSet.next()) break block7;
            boolean bl2 = ENGINE.equalsIgnoreCase(StringUtils.trimToNull((String)resultSet.getString(1)));
            JRA24857Check.silentlyClose(resultSet);
            JRA24857Check.silentlyClose(statement);
            JRA24857Check.silentlyClose(connection);
            return bl2;
        }
        try {
            log.warn((Object)"Unable to detect MySQL engine type. Assuming correct engine type.");
            bl = false;
        }
        catch (SQLException e) {
            boolean bl3;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to detect MySQL engine type.", (Throwable)e);
                } else {
                    log.warn((Object)"Unable to detect MySQL engine type. Assuming correct engine type.");
                }
                bl3 = false;
            }
            catch (Throwable throwable) {
                JRA24857Check.silentlyClose(resultSet);
                JRA24857Check.silentlyClose(statement);
                JRA24857Check.silentlyClose(connection);
                throw throwable;
            }
            JRA24857Check.silentlyClose(resultSet);
            JRA24857Check.silentlyClose(statement);
            JRA24857Check.silentlyClose(connection);
            return bl3;
        }
        JRA24857Check.silentlyClose(resultSet);
        JRA24857Check.silentlyClose(statement);
        JRA24857Check.silentlyClose(connection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Set<String> getMyISAMTables() {
        Set<String> set;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.factory.getConnection();
            String catalog = connection.getCatalog();
            statement = connection.prepareStatement("select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = ? and engine = ?", 1003, 1007);
            statement.setString(1, catalog);
            statement.setString(2, ENGINE);
            resultSet = statement.executeQuery();
            Set<String> set2 = JRA24857Check.createTableSet();
            while (resultSet.next()) {
                set2.add(StringUtils.trimToNull((String)resultSet.getString(1)));
            }
            set = set2;
        }
        catch (SQLException e) {
            Set<String> set3;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to read DB metadata from INFROMATION_SCHEMA.", (Throwable)e);
                } else {
                    log.warn((Object)"Unable to read DB metadata from INFROMATION_SCHEMA. Assuming correct MySQL engine.");
                }
                set3 = Collections.emptySet();
            }
            catch (Throwable throwable) {
                JRA24857Check.silentlyClose(resultSet);
                JRA24857Check.silentlyClose(statement);
                JRA24857Check.silentlyClose(connection);
                throw throwable;
            }
            JRA24857Check.silentlyClose(resultSet);
            JRA24857Check.silentlyClose(statement);
            JRA24857Check.silentlyClose(connection);
            return set3;
        }
        JRA24857Check.silentlyClose(resultSet);
        JRA24857Check.silentlyClose(statement);
        JRA24857Check.silentlyClose(connection);
        return set;
    }

    @VisibleForTesting
    Set<String> getJiraTables() {
        ModelReader modelReader = this.delegatorInterface.getModelReader();
        try {
            Set<String> tables = JRA24857Check.createTableSet();
            for (String name : modelReader.getEntityNames()) {
                ModelEntity modelEntity = modelReader.getModelEntity(name);
                if (modelEntity instanceof ModelViewEntity) continue;
                tables.add(modelEntity.getPlainTableName());
            }
            return tables;
        }
        catch (GenericEntityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to read DB configuration.", (Throwable)e);
            } else {
                log.warn((Object)"Unable to read DB configuration. Assuming correct MySQL engine.");
            }
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isMySQL() {
        Connection connection = null;
        try {
            connection = this.factory.getConnection();
            DatabaseMetaData dbMeta = connection.getMetaData();
            String productName = dbMeta.getDatabaseProductName();
            boolean bl = productName != null && productName.contains("MySQL");
            return bl;
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to detect database type.", (Throwable)e);
            } else {
                log.warn((Object)"Unable to detect database type. Assuming not MySQL.");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JRA24857Check.silentlyClose(connection);
        }
    }

    private static Set<String> createTableSet() {
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    private static void silentlyClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void silentlyClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void silentlyClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

