/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.util.system.VersionNumber;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import javax.servlet.ServletContext;

class JRA10145Check
implements SystemEnvironmentCheck {
    private static final String LIMIT_BUFFER = "org.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER";
    final VersionNumber v5 = new VersionNumber("5.0");
    final VersionNumber v5_5 = new VersionNumber("5.5");
    final VersionNumber v5_5_15 = new VersionNumber("5.5.15");
    final VersionNumber v6 = new VersionNumber("6.0");

    JRA10145Check() {
    }

    @Override
    public I18nMessage getWarningMessage() {
        ServletContext context = ServletContextProvider.getServletContext();
        String serverInfo = context.getServerInfo();
        if (serverInfo.indexOf("Tomcat") >= 0) {
            VersionNumber versionNumber = new VersionNumber(serverInfo.substring(serverInfo.indexOf("/") + 1));
            if (versionNumber.isLessThan(this.v5)) {
                return null;
            }
            if (versionNumber.isLessThan(this.v5_5_15)) {
                I18nMessage warning = new I18nMessage("admin.warning.tomcat.version");
                warning.addParameter(serverInfo);
                warning.addParameter(LIMIT_BUFFER);
                warning.setLink(new VersionLink().getMoreInfo(versionNumber));
                return warning;
            }
            if (!Boolean.getBoolean(LIMIT_BUFFER)) {
                I18nMessage warning = new I18nMessage("admin.warning.tomcat.limitbuffer");
                warning.addParameter(serverInfo);
                warning.addParameter(LIMIT_BUFFER);
                warning.setLink(new VersionLink().getMoreInfo(versionNumber));
                return warning;
            }
        }
        return null;
    }

    private final class VersionLink {
        private final String MORE_INFO = ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.confluence.tomcat");

        private VersionLink() {
        }

        String getMoreInfo(VersionNumber version) {
            if (version.isLessThan(JRA10145Check.this.v5)) {
                throw new IllegalStateException("We do not have information on this problem for version 4, only version 5 and above");
            }
            if (version.isLessThan(JRA10145Check.this.v5_5)) {
                return this.MORE_INFO + "tomcat50.html";
            }
            if (version.isLessThan(JRA10145Check.this.v6)) {
                return this.MORE_INFO + "tomcat55.html";
            }
            return this.MORE_INFO + "tomcat60.html";
        }
    }
}

