/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class UnsupportedBrowserManager {
    private ApplicationProperties properties;
    private Map<UserAgentUtil.Browser, String> unsupportedBrowsers;

    public UnsupportedBrowserManager(ApplicationProperties properties) {
        this.properties = properties;
        this.unsupportedBrowsers = MapBuilder.newBuilder((Object)new UserAgentUtil.Browser(UserAgentUtil.BrowserFamily.MSIE, UserAgentUtil.BrowserMajorVersion.MSIE6, "MSIE6.0"), (Object)"browser.ie6.nosupport", (Object)new UserAgentUtil.Browser(UserAgentUtil.BrowserFamily.MSIE, UserAgentUtil.BrowserMajorVersion.MSIE7, "MSIE7.0"), (Object)"browser.ie7.nosupport").toMap();
    }

    public Map<UserAgentUtil.Browser, String> getUnsupportedBrowsers() {
        return this.unsupportedBrowsers;
    }

    public void addUnsupportedBrowser(UserAgentUtil.Browser browser, String message) {
        if (browser != null && message != null) {
            this.unsupportedBrowsers = MapBuilder.newBuilder(this.unsupportedBrowsers).add((Object)browser, (Object)message).toMap();
        }
    }

    public boolean isUnsupportedBrowser(UserAgentUtil.Browser browser) {
        return this.unsupportedBrowsers.containsKey(browser);
    }

    public boolean isUnsupportedBrowser(HttpServletRequest request) {
        return this.isUnsupportedBrowser(this.getBrowser(request));
    }

    public String getMessageKey(UserAgentUtil.Browser browser) {
        return this.unsupportedBrowsers.get(browser);
    }

    public String getMessageKey(HttpServletRequest request) {
        return this.unsupportedBrowsers.get(this.getBrowser(request));
    }

    public boolean isCheckEnabled() {
        return "false".equals(this.properties.getDefaultString("jira.browser.unsupported.warnings.disabled"));
    }

    public boolean isHandledCookiePresent(HttpServletRequest request) {
        if (request != null && request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals("UNSUPPORTED_BROWSER_WARNING")) continue;
                return true;
            }
        }
        return false;
    }

    public UserAgentUtil.Browser getBrowser(HttpServletRequest request) {
        if (request != null) {
            String userAgent = request.getHeader("USER-AGENT");
            UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
            return userAgentUtil.getUserAgentInfo(userAgent).getBrowser();
        }
        return null;
    }
}

