/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SneakyAutoLoginUtil {
    private static final Logger log = Logger.getLogger(SneakyAutoLoginUtil.class);

    public static boolean logUserIn(String username, HttpServletRequest request) {
        UserManager userManager = ComponentAccessor.getUserManager();
        User user = userManager.getUser(username);
        return SneakyAutoLoginUtil.logUserIn(user, request);
    }

    public static boolean logUserIn(User user, HttpServletRequest request) {
        if (user == null) {
            log.warn((Object)"Unable to automatically log in: user is null");
        } else {
            try {
                CrowdService crowdService = ComponentAccessor.getCrowdService();
                if (crowdService != null) {
                    User principal = crowdService.getUser(user.getName());
                    request.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)principal);
                    request.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
                    return true;
                }
                log.warn((Object)"Unable to automatically log in: crowdService is null");
            }
            catch (Exception e) {
                log.warn((Object)"Error with automatic log in. The user will need to log in manually.", (Throwable)e);
            }
        }
        return false;
    }
}

