/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DirectorySynchroniserBarrier {
    private final ApplicationFactory applicationFactory;
    private final CrowdDirectoryService crowdDirectoryService;
    private final EventPublisher publisher;
    private final long pollingPeriod;
    private final BlockingQueue<Long> queue = new LinkedBlockingQueue<Long>();

    public DirectorySynchroniserBarrier(ApplicationFactory applicationFactory, CrowdDirectoryService crowdDirectoryService, EventPublisher publisher) {
        this(applicationFactory, crowdDirectoryService, publisher, TimeUnit.SECONDS.toMillis(1L));
    }

    @VisibleForTesting
    DirectorySynchroniserBarrier(ApplicationFactory applicationFactory, CrowdDirectoryService crowdDirectoryService, EventPublisher publisher, long pollingPeriod) {
        this.applicationFactory = applicationFactory;
        this.crowdDirectoryService = crowdDirectoryService;
        this.publisher = publisher;
        this.pollingPeriod = pollingPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) {
        if (this.applicationFactory.getApplication() == null) {
            return true;
        }
        long current = System.currentTimeMillis();
        long deadLine = System.currentTimeMillis() + unit.toMillis(timeout);
        this.publisher.register((Object)this);
        try {
            boolean synchroniseRunning = this.isSynchroniseRunning();
            while (synchroniseRunning && current < deadLine) {
                this.queue.poll(Math.min(this.pollingPeriod, deadLine - current), TimeUnit.MILLISECONDS);
                synchroniseRunning = this.isSynchroniseRunning();
                current = System.currentTimeMillis();
            }
            boolean bl = !synchroniseRunning;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = !this.isSynchroniseRunning();
            return bl;
        }
        finally {
            this.publisher.unregister((Object)this);
        }
    }

    @EventListener
    public void onDirectoryFinished(RemoteDirectorySynchronisedEvent finished) {
        try {
            this.queue.put(finished.getRemoteDirectory().getDirectoryId());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isSynchroniseRunning() {
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (!directory.isActive() || !this.crowdDirectoryService.isDirectorySynchronising(directory.getId().longValue())) continue;
            return true;
        }
        return false;
    }
}

