/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.GlobalShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;

public class GlobalShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;

    public GlobalShareTypeValidator(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"ctx.user", (Object)ctx.getLoggedInUser());
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.equals((String)GlobalShareType.TYPE.toString(), (Object)GlobalShareType.TYPE, (Object)permission.getType());
        boolean hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInUser());
        if (!hasPermission) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        }
        return hasPermission;
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)GlobalShareType.TYPE.toString(), (Object)GlobalShareType.TYPE, (Object)searchParameter.getType());
        return true;
    }
}

