/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfDefaults;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.config.Configuration;
import webwork.config.util.ActionInfo;

public class DefaultXsrfInvocationChecker
implements XsrfInvocationChecker {
    private final ComponentLocator componentLocator;
    private static final String NO_CHECK = "no-check";

    public DefaultXsrfInvocationChecker(ComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }

    public XsrfCheckResult checkActionInvocation(Action action, Map<String, ?> parameters) {
        Null.not("action", action);
        Null.not("parameters", parameters);
        return this.checkInvocation(action, parameters, this.getActionHttpRequest());
    }

    public XsrfCheckResult checkWebRequestInvocation(HttpServletRequest httpServletRequest) {
        Map parameters = httpServletRequest.getParameterMap();
        Null.not("httpServletRequest", httpServletRequest);
        Null.not("httpServletRequest.parameters", parameters);
        return this.checkInvocation(null, parameters, httpServletRequest);
    }

    private XsrfCheckResult checkInvocation(Action action, Map<String, ?> parameters, HttpServletRequest httpRequest) {
        if (this.needsXsrfCheck(action, httpRequest)) {
            String token = this.getXsrfToken(parameters);
            XsrfTokenGenerator tokenGenerator = this.getXsrfTokenGenerator();
            boolean passed = tokenGenerator.validateToken(httpRequest, token);
            boolean authed = tokenGenerator.generatedByAuthenticatedUser(token);
            return DefaultXsrfInvocationChecker.createResult(true, passed, authed);
        }
        return DefaultXsrfInvocationChecker.createResult(false, true, true);
    }

    private static XsrfCheckResult createResult(final boolean required, final boolean passed, final boolean authed) {
        return new XsrfCheckResult(){

            public boolean isRequired() {
                return required;
            }

            public boolean isValid() {
                return passed;
            }

            public boolean isGeneratedForAuthenticatedUser() {
                return authed;
            }

            public String toString() {
                return String.format("required=%b valid=%b authed=%b", required, passed, authed);
            }
        };
    }

    private boolean needsXsrfCheck(Action action, HttpServletRequest httpRequest) {
        if (this.requestHasOptOutHeader(httpRequest)) {
            return false;
        }
        XsrfDefaults defaults = this.getXsrfDefaults();
        if (!defaults.isXsrfProtectionEnabled()) {
            return false;
        }
        if (action == null) {
            return true;
        }
        if (action instanceof JiraWebActionSupport) {
            return this.checkActionAnnotations((JiraWebActionSupport)action);
        }
        return false;
    }

    private boolean requestHasOptOutHeader(HttpServletRequest httpRequest) {
        String tokenValue;
        return httpRequest != null && StringUtils.isNotBlank((String)(tokenValue = httpRequest.getHeader("X-Atlassian-Token"))) && NO_CHECK.equals(tokenValue.trim().toLowerCase());
    }

    private boolean checkActionAnnotations(@NonNull JiraWebActionSupport action) {
        Method method;
        String command = action.getCommandName();
        if (StringUtils.isBlank((String)command)) {
            command = "execute";
        }
        if ((method = this.getMethod(action, command)) != null) {
            return method.isAnnotationPresent(RequiresXsrfCheck.class);
        }
        return false;
    }

    private Method getMethod(JiraWebActionSupport action, String command) {
        String methodName = "do" + StringUtils.capitalize((String)command);
        return this.getMethod(action.getClass(), methodName);
    }

    private Method getMethod(Class clazz, String methodName) {
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.equals(JiraWebActionSupport.class)) {
                return null;
            }
            return this.getMethod(clazz.getSuperclass(), methodName);
        }
    }

    HttpServletRequest getActionHttpRequest() {
        return ActionContext.getRequest();
    }

    ActionInfo getActionInfo(String magicKey) {
        return (ActionInfo)Configuration.get((String)magicKey);
    }

    private String getXsrfToken(Map<String, ?> parameters) {
        String[] tokenArr;
        Object mapObj = parameters.get("atl_token");
        if (mapObj instanceof String[] && (tokenArr = (String[])mapObj).length > 0) {
            return tokenArr[0];
        }
        return null;
    }

    private XsrfDefaults getXsrfDefaults() {
        return (XsrfDefaults)this.componentLocator.getComponentInstanceOfType(XsrfDefaults.class);
    }

    private XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)this.componentLocator.getComponentInstanceOfType(XsrfTokenGenerator.class);
    }
}

