/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class CachingVersionStore
implements VersionStore {
    private static final Logger log = Logger.getLogger(CachingVersionStore.class);
    private final VersionStore delegate;
    private volatile VersionCache versionCache;

    public CachingVersionStore(VersionStore delegate) {
        this.delegate = delegate;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshCache();
    }

    @Override
    public List<GenericValue> getAllVersions() {
        return Collections.unmodifiableList(new ArrayList<GenericValue>(this.getVersionCache().getAllVersionsCache().values()));
    }

    @Override
    public GenericValue getVersion(Long id) {
        return this.getVersionCache().getAllVersionsCache().get(id);
    }

    @Override
    public GenericValue createVersion(Map<String, Object> versionParams) {
        GenericValue version = this.delegate.createVersion(versionParams);
        this.refreshCache();
        return version;
    }

    @Override
    public void storeVersion(Version version) {
        this.delegate.storeVersion(version);
        this.refreshCache();
    }

    @Override
    public void storeVersions(Collection<Version> versions) {
        this.delegate.storeVersions(versions);
        this.refreshCache();
    }

    @Override
    public void deleteVersion(GenericValue versionGV) {
        this.delegate.deleteVersion(versionGV);
        this.refreshCache();
    }

    @Override
    public List<GenericValue> getVersionsByName(String name) {
        List<GenericValue> versions = this.getVersionCache().getVersionCacheByName().get(name.toLowerCase());
        if (versions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(versions);
    }

    @Override
    public List<GenericValue> getVersionsByProject(Long projectId) {
        List<GenericValue> versions = this.getVersionCache().getVersionCacheByProject().get(projectId);
        if (versions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(versions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionCache getVersionCache() {
        VersionCache currentVersionCache = this.versionCache;
        if (currentVersionCache == null) {
            log.debug((Object)"VersionCache is null - getting a lock to initialise the cache.");
            CachingVersionStore cachingVersionStore = this;
            synchronized (cachingVersionStore) {
                if (this.versionCache == null) {
                    this.loadCache();
                } else {
                    log.debug((Object)"VersionCache was created by another thread - no need to initialise.");
                }
                return this.versionCache;
            }
        }
        return currentVersionCache;
    }

    private synchronized void refreshCache() {
        log.debug((Object)"Versions changed - cache refresh required.");
        this.loadCache();
    }

    private synchronized void loadCache() {
        log.debug((Object)"Loading the cache.");
        LinkedHashMap<Long, GenericValue> newVersionCache = new LinkedHashMap<Long, GenericValue>();
        HashMap<Long, ArrayList<GenericValue>> newVersionCacheByProject = new HashMap<Long, ArrayList<GenericValue>>();
        HashMap<String, ArrayList<GenericValue>> newVersionCacheByName = new HashMap<String, ArrayList<GenericValue>>();
        List<GenericValue> versions = this.delegate.getAllVersions();
        for (GenericValue version : versions) {
            newVersionCache.put(version.getLong("id"), version);
            Long projectId = version.getLong("project");
            ArrayList<GenericValue> projectCache = (ArrayList<GenericValue>)newVersionCacheByProject.get(projectId);
            if (projectCache == null) {
                projectCache = new ArrayList<GenericValue>();
                newVersionCacheByProject.put(projectId, projectCache);
            }
            projectCache.add(version);
            String name = version.getString("name");
            if (name == null) continue;
            ArrayList<GenericValue> nameCache = (ArrayList<GenericValue>)newVersionCacheByName.get(name = name.toLowerCase());
            if (nameCache == null) {
                nameCache = new ArrayList<GenericValue>();
                newVersionCacheByName.put(name, nameCache);
            }
            nameCache.add(version);
        }
        log.debug((Object)"Committing new cache.");
        this.versionCache = new VersionCache(newVersionCache, newVersionCacheByProject, newVersionCacheByName);
        log.debug((Object)"Cache load complete.");
    }

    private class VersionCache {
        private Map<Long, GenericValue> allVersionsCache;
        private Map<Long, List<GenericValue>> versionCacheByProject;
        private Map<String, List<GenericValue>> versionCacheByName;

        private VersionCache(Map<Long, GenericValue> allVersionsCache, Map<Long, List<GenericValue>> versionCacheByProject, Map<String, List<GenericValue>> versionCacheByName) {
            this.allVersionsCache = Collections.unmodifiableMap(allVersionsCache);
            this.versionCacheByProject = Collections.unmodifiableMap(versionCacheByProject);
            this.versionCacheByName = Collections.unmodifiableMap(versionCacheByName);
        }

        public Map<Long, GenericValue> getAllVersionsCache() {
            return this.allVersionsCache;
        }

        public Map<Long, List<GenericValue>> getVersionCacheByProject() {
            return this.versionCacheByProject;
        }

        public Map<String, List<GenericValue>> getVersionCacheByName() {
            return this.versionCacheByName;
        }
    }
}

