/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPermissionPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.jira.security.Permissions;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Map;

public class WorkflowPermissionValidatorPluginFactory
extends AbstractWorkflowPermissionPluginFactory
implements WorkflowPluginValidatorFactory {
    private final SchemePermissions schemePermissions;

    public WorkflowPermissionValidatorPluginFactory(SchemePermissions schemePermissions) {
        super(schemePermissions);
        this.schemePermissions = schemePermissions;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        velocityParams.put("permission", this.getPermissionId(descriptor));
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        velocityParams.put("permission", this.schemePermissions.getPermissionName(this.getPermissionId(descriptor)));
    }

    public Map getDescriptorParams(Map conditionParams) {
        String value = this.extractSingleParam(conditionParams, "permission");
        int permissionId = Integer.parseInt(value);
        return EasyMap.build((Object)"permission", (Object)Permissions.getShortName((int)permissionId));
    }

    private Integer getPermissionId(AbstractDescriptor descriptor) {
        if (!(descriptor instanceof ValidatorDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ValidatorDescriptor.");
        }
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        String shortName = (String)validatorDescriptor.getArgs().get("permission");
        return new Integer(Permissions.getType((String)shortName));
    }
}

