/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCopiedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCreatedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultPermissionSchemeManager
extends AbstractSchemeManager
implements PermissionSchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultPermissionSchemeManager.class);
    private static final String SCHEME_ENTITY_NAME = "PermissionScheme";
    private static final String PERMISSION_ENTITY_NAME = "SchemePermissions";
    private static final String SCHEME_DESC = "Permission";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.permissions.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.permissions.default.desc";
    private final Cache<Long, SchemeEntityCacheEntry> schemeEntityCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, SchemeEntityCacheEntry>(){

        public SchemeEntityCacheEntry load(Long key) throws Exception {
            SchemeEntityCacheEntry cacheEntry = new SchemeEntityCacheEntry();
            cacheEntry.load(key);
            return cacheEntry;
        }
    });
    private final PermissionTypeManager permissionTypeManager;
    private final OfBizDelegator delegator;
    private final EventPublisher eventPublisher;

    public DefaultPermissionSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, OfBizDelegator delegator, SchemeFactory schemeFactory, AssociationManager associationManager, GroupManager groupManager, EventPublisher eventPublisher) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, delegator, groupManager);
        this.permissionTypeManager = permissionTypeManager;
        this.delegator = delegator;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(DefaultPermissionSchemeManager.class.getSimpleName()).addCache(this.schemeEntityCache).install();
    }

    @Override
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.flushSchemeEntities();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return PERMISSION_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    @Override
    public Scheme createSchemeObject(String name, String description) {
        Scheme scheme = super.createSchemeObject(name, description);
        if (scheme != null) {
            this.eventPublisher.publish((Object)new PermissionSchemeCreatedEvent(scheme));
        }
        return scheme;
    }

    @Override
    public Scheme copyScheme(Scheme scheme) {
        Scheme result = super.copyScheme(scheme);
        if (result != null) {
            this.eventPublisher.publish((Object)new PermissionSchemeCopiedEvent(scheme, result));
        }
        return result;
    }

    @Override
    public void updateScheme(Scheme scheme) throws DataAccessException {
        super.updateScheme(scheme);
        this.eventPublisher.publish((Object)new PermissionSchemeUpdatedEvent(scheme));
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        super.deleteScheme(id);
        this.eventPublisher.publish((Object)new PermissionSchemeDeletedEvent(id));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId) throws GenericEntityException {
        Long key = this.getSchemeEntityCacheKey(scheme);
        try {
            List<GenericValue> genericValues = ((SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)key)).getCacheByPermission().get(permissionId);
            if (genericValues == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableList(genericValues);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionId), Collections.singletonMap("parameter", parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String type, String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionId), (Map)MapBuilder.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long permissionId) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionId), Collections.singletonMap("type", type));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Permission scheme IDs must be Long values.");
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed must NOT be null");
        }
        if (!(schemeEntity.getEntityTypeId() instanceof Long) && !(schemeEntity.getEntityTypeId() instanceof Integer)) {
            throw new IllegalArgumentException("Permission scheme IDs must be long or int values, not:" + schemeEntity.getEntityTypeId().getClass());
        }
        if (schemeEntity.getType() == null) {
            throw new IllegalArgumentException("Type in SchemeEntity can NOT be null");
        }
        GenericValue perm = EntityUtils.createValue(PERMISSION_ENTITY_NAME, MapBuilder.newBuilder((Object)"scheme", (Object)scheme.getLong("id")).add((Object)"permission", schemeEntity.getEntityTypeId()).add((Object)"type", (Object)schemeEntity.getType()).add((Object)"parameter", (Object)schemeEntity.getParameter()).toMap());
        this.eventPublisher.publish((Object)new PermissionAddedEvent(scheme.getLong("id"), schemeEntity));
        this.schemeEntityCache.invalidate((Object)this.getSchemeEntityCacheKey(scheme));
        return perm;
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        super.deleteEntity(id);
        this.eventPublisher.publish((Object)new PermissionDeletedEvent(id));
        this.flushSchemeEntities();
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)entity.getLong("permission"));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        Long key = this.getSchemeEntityCacheKey(scheme);
        try {
            return Collections.unmodifiableList(((SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)key)).getCache());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        boolean result = super.removeEntities(type, parameter);
        this.flushSchemeEntities();
        return result;
    }

    @Override
    public boolean removeEntities(GenericValue scheme, Long permissionId) throws RemoveException {
        if (Permissions.isGlobalPermission((int)permissionId.intValue())) {
            throw new IllegalArgumentException("PermissionId passed must not be a global permissions " + permissionId.toString() + " is global");
        }
        boolean result = super.removeEntities(scheme, permissionId);
        this.schemeEntityCache.invalidate((Object)this.getSchemeEntityCacheKey(scheme));
        return result;
    }

    public boolean hasSchemeAuthority(Long permissionId, GenericValue project) {
        return this.hasPermission(permissionId, project, null, false);
    }

    public boolean hasSchemeAuthority(Long permissionId, GenericValue project, User user, boolean issueCreation) {
        if (user == null) {
            throw new IllegalArgumentException("The user passed must not be null");
        }
        return this.hasPermission(permissionId, project, user, issueCreation);
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        return this.getGroups(entityTypeId, project.getGenericValue());
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        if (Permissions.isGlobalPermission((int)entityTypeId.intValue())) {
            throw new IllegalArgumentException("PermissionId passed can NOT be a global permission " + entityTypeId.toString() + " is a global");
        }
        return super.getGroups(entityTypeId, project);
    }

    private boolean hasPermission(Long permissionId, GenericValue entity, User user, boolean issueCreation) {
        if (Permissions.isGlobalPermission((int)permissionId.intValue())) {
            throw new IllegalArgumentException("permissionId passed to this function must NOT be a global permission, " + permissionId + " is not");
        }
        if (entity == null) {
            throw new IllegalArgumentException("The entity passed must not be null");
        }
        if (!"Project".equals(entity.getEntityName()) && !"Issue".equals(entity.getEntityName())) {
            throw new IllegalArgumentException("The entity passed must be a Project or an Issue not a " + entity.getEntityName());
        }
        try {
            Map types = this.permissionTypeManager.getTypes();
            List schemes = Collections.emptyList();
            if ("Project".equals(entity.getEntityName())) {
                schemes = ManagerFactory.getPermissionSchemeManager().getSchemes(entity);
            } else if ("Issue".equals(entity.getEntityName())) {
                GenericValue project = ManagerFactory.getProjectManager().getProject(entity);
                schemes = ManagerFactory.getPermissionSchemeManager().getSchemes(project);
            }
            for (GenericValue scheme : schemes) {
                if (!this.hasSchemePermission(permissionId, scheme, entity, user, issueCreation, types)) continue;
                return true;
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
        return false;
    }

    boolean hasSchemePermission(Long permissionId, GenericValue scheme, GenericValue entity, User user, boolean issueCreation) throws GenericEntityException {
        Map types = this.permissionTypeManager.getTypes();
        return this.hasSchemePermission(permissionId, scheme, entity, user, issueCreation, types);
    }

    private boolean hasSchemePermission(Long permissionId, GenericValue scheme, GenericValue entity, User user, boolean issueCreation, Map<?, ?> types) throws GenericEntityException {
        List<GenericValue> entities = this.getEntities(scheme, permissionId);
        for (GenericValue perm : entities) {
            if (perm == null) continue;
            SchemeType type = (SchemeType)types.get(perm.getString("type"));
            if (!(user == null ? type.hasPermission(entity, perm.getString("parameter")) : (permissionId == null || type.isValidForPermission(permissionId.intValue())) && type.hasPermission(entity, perm.getString("parameter"), user, issueCreation))) continue;
            return true;
        }
        return false;
    }

    private Long getSchemeEntityCacheKey(GenericValue scheme) {
        return scheme.getLong("id");
    }

    public void flushSchemeEntities() {
        this.schemeEntityCache.invalidateAll();
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.delegator.findByAnd(PERMISSION_ENTITY_NAME, EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
        HashSet<Long> schemeIds = new HashSet<Long>();
        ArrayList<EntityExpr> entityConditions = new ArrayList<EntityExpr>();
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        for (Long id : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)id));
        }
        List schemes = !entityConditions.isEmpty() ? this.delegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.EMPTY_LIST) : Collections.emptyList();
        return schemes;
    }

    private class SchemeEntityCacheEntry {
        private List<GenericValue> cache = null;
        private final Map<Long, List<GenericValue>> cacheByPermission = new HashMap<Long, List<GenericValue>>();

        private SchemeEntityCacheEntry() {
        }

        public List<GenericValue> getCache() {
            return this.cache;
        }

        public Map<Long, List<GenericValue>> getCacheByPermission() {
            return this.cacheByPermission;
        }

        public void load(Long key) {
            List schemeEntities;
            try {
                GenericValue scheme = DefaultPermissionSchemeManager.super.getScheme(key);
                schemeEntities = DefaultPermissionSchemeManager.super.getEntities(scheme);
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
            this.cache = schemeEntities;
            for (GenericValue entity : schemeEntities) {
                Long permissionId = entity.getLong("permission");
                List<GenericValue> entitiesForPermission = this.cacheByPermission.get(permissionId);
                if (entitiesForPermission == null) {
                    entitiesForPermission = new ArrayList<GenericValue>();
                    this.cacheByPermission.put(permissionId, entitiesForPermission);
                }
                entitiesForPermission.add(entity);
            }
        }
    }
}

