/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.mail.JiraMailPluginsHelper;
import com.atlassian.jira.mail.JiraMailPluginsHelperImpl;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtils;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.JiraVelocityHelper;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MemoizingMap;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.velocity.VelocityHelper;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class JiraMailQueueUtils {
    private static final JiraUtils JIRA_UTILS = new JiraUtils();
    private static final JiraKeyUtils JIRA_KEY_UTILS = new JiraKeyUtils();
    private static final BuildUtils BUILD_UTILS = new BuildUtils();
    private static final UserUtils USER_UTILS = new UserUtils();
    private static final TextUtils TEXT_UTILS = new TextUtils();
    private static final VelocityHelper VELOCITY_HELPER = new VelocityHelper();
    private static final MemoizingMap.Master<String, Object> MASTER;

    public static Map<String, Object> getContextParamsBody(Map<String, Object> params) {
        return MASTER.toMap(params);
    }

    public static MemoizingMap.Master<String, Object> getContextParamsMaster() {
        return MASTER;
    }

    static {
        MemoizingMap.Master.Builder<String, Object> builder = MemoizingMap.Master.builder();
        builder.add("jirautils", JIRA_UTILS);
        builder.add("jirakeyutils", JIRA_KEY_UTILS);
        builder.add("buildutils", BUILD_UTILS);
        builder.add("urlModeAbsolute", UrlMode.ABSOLUTE);
        builder.add("userutils", USER_UTILS);
        builder.add("velocityhelper", VELOCITY_HELPER);
        builder.add("textutils", TEXT_UTILS);
        builder.addLazy("constantsManager", new Supplier<ConstantsManager>(){

            public ConstantsManager get() {
                return ComponentAccessor.getConstantsManager();
            }
        });
        builder.addLazy("projectManager", new Supplier<ProjectManager>(){

            public ProjectManager get() {
                return ComponentAccessor.getProjectManager();
            }
        });
        builder.addLazy("customFieldManager", new Supplier<CustomFieldManager>(){

            public CustomFieldManager get() {
                return ComponentAccessor.getCustomFieldManager();
            }
        });
        builder.addLazy("applicationProperties", new Supplier<ApplicationProperties>(){

            public ApplicationProperties get() {
                return ComponentAccessor.getApplicationProperties();
            }
        });
        builder.addLazy("jiraUserUtils", new Supplier<UserUtil>(){

            public UserUtil get() {
                return ComponentAccessor.getUserUtil();
            }
        });
        builder.addLazy("mailPluginsHelper", new Supplier<JiraMailPluginsHelper>(){

            public JiraMailPluginsHelper get() {
                return new JiraMailPluginsHelperImpl(ComponentAccessor.getPluginAccessor());
            }
        });
        builder.addLazy("userformat", new Supplier<UserFormatManager>(){

            public UserFormatManager get() {
                return ComponentManager.getComponentInstanceOfType(UserFormatManager.class);
            }
        });
        builder.addLazy("webResourceManager", new Supplier<WebResourceManager>(){

            public WebResourceManager get() {
                return ComponentAccessor.getWebResourceManager();
            }
        });
        builder.addLazy("avatarService", new Supplier<AvatarService>(){

            public AvatarService get() {
                return ComponentManager.getComponent(AvatarService.class);
            }
        });
        builder.addLazy("velocityhelper", new Supplier<JiraVelocityHelper>(){

            public JiraVelocityHelper get() {
                return new JiraVelocityHelper(ComponentManager.getInstance().getFieldManager());
            }
        });
        MASTER = builder.master();
    }
}

