/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.issue.worklog.WorklogStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizWorklogStore
implements WorklogStore {
    private final OfBizDelegator ofBizDelegator;
    private final IssueManager issueManager;
    private WorklogManager worklogManager;
    public static final String WORKLOG_ENTITY = "Worklog";

    public OfBizWorklogStore(OfBizDelegator ofBizDelegator, IssueManager issueManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueManager = issueManager;
    }

    @Override
    public Worklog update(Worklog worklog) {
        Map fields = this.createParamMap(worklog);
        GenericValue worklogGV = this.ofBizDelegator.findById(WORKLOG_ENTITY, worklog.getId());
        if (worklogGV == null) {
            throw new IllegalArgumentException("Could not find original worklog entity to update.");
        }
        worklogGV.setFields(fields);
        try {
            worklogGV.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        return this.convertToWorklog(worklog.getIssue(), worklogGV);
    }

    @Override
    public Worklog create(Worklog worklog) {
        Map fields = this.createParamMap(worklog);
        GenericValue worklogGV = this.ofBizDelegator.createValue(WORKLOG_ENTITY, fields);
        return this.convertToWorklog(worklog.getIssue(), worklogGV);
    }

    @Override
    public boolean delete(Long worklogId) {
        if (worklogId == null) {
            throw new IllegalArgumentException("Cannot remove a worklog with id null.");
        }
        int numRemoved = this.ofBizDelegator.removeByAnd(WORKLOG_ENTITY, EasyMap.build((Object)"id", (Object)worklogId));
        return numRemoved == 1;
    }

    Map createParamMap(Worklog worklog) {
        if (worklog == null) {
            throw new IllegalArgumentException("Cannot store a null worklog.");
        }
        if (worklog.getIssue() == null) {
            throw new IllegalArgumentException("Cannot store a worklog against a null issue.");
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", worklog.getIssue().getId());
        fields.put("author", worklog.getAuthor());
        fields.put("updateauthor", worklog.getUpdateAuthor());
        fields.put("body", worklog.getComment());
        fields.put("grouplevel", worklog.getGroupLevel());
        fields.put("rolelevel", worklog.getRoleLevelId());
        fields.put("timeworked", worklog.getTimeSpent());
        fields.put("startdate", new Timestamp(worklog.getStartDate().getTime()));
        fields.put("created", new Timestamp(worklog.getCreated().getTime()));
        fields.put("updated", new Timestamp(worklog.getUpdated().getTime()));
        return fields;
    }

    @Override
    public Worklog getById(Long id) {
        Worklog worklog = null;
        GenericValue worklogGV = this.ofBizDelegator.findById(WORKLOG_ENTITY, id);
        if (worklogGV != null) {
            Issue issue = this.getIssueForId(worklogGV.getLong("issue"));
            worklog = this.convertToWorklog(issue, worklogGV);
        }
        return worklog;
    }

    @Override
    public List<Worklog> getByIssue(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Cannot resolve worklogs for null issue.");
        }
        ArrayList<Worklog> worklogs = new ArrayList<Worklog>();
        List worklogGVs = this.ofBizDelegator.findByAnd(WORKLOG_ENTITY, EasyMap.build((Object)"issue", (Object)issue.getId()), EasyList.build((Object)"created ASC"));
        for (GenericValue worklogGV : worklogGVs) {
            worklogs.add(this.convertToWorklog(issue, worklogGV));
        }
        return worklogs;
    }

    @Override
    public int swapWorklogGroupRestriction(String groupName, String swapGroup) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        if (swapGroup == null) {
            throw new IllegalArgumentException("You must provide a non null swap group name.");
        }
        return this.ofBizDelegator.bulkUpdateByAnd(WORKLOG_ENTITY, EasyMap.build((Object)"grouplevel", (Object)swapGroup), EasyMap.build((Object)"grouplevel", (Object)groupName));
    }

    @Override
    public long getCountForWorklogsRestrictedByGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        EntityFieldMap condition = new EntityFieldMap(EasyMap.build((Object)"grouplevel", (Object)groupName), EntityOperator.AND);
        List worklogCount = this.ofBizDelegator.findByCondition("WorklogCount", (EntityCondition)condition, (Collection)EasyList.build((Object)"count"), Collections.EMPTY_LIST);
        if (worklogCount != null && worklogCount.size() == 1) {
            GenericValue worklogCountGV = (GenericValue)worklogCount.get(0);
            return worklogCountGV.getLong("count");
        }
        throw new DataAccessException("Unable to access the count for the Worklog table");
    }

    Worklog convertToWorklog(Issue issue, GenericValue gv) {
        Timestamp startDateTS = gv.getTimestamp("startdate");
        Timestamp createdTS = gv.getTimestamp("created");
        Timestamp updatedTS = gv.getTimestamp("updated");
        WorklogImpl worklog = new WorklogImpl(this.getWorklogManager(), issue, gv.getLong("id"), gv.getString("author"), gv.getString("body"), startDateTS == null ? null : new Date(startDateTS.getTime()), gv.getString("grouplevel"), gv.getLong("rolelevel"), gv.getLong("timeworked"), gv.getString("updateauthor"), createdTS == null ? null : new Date(createdTS.getTime()), updatedTS == null ? null : new Date(updatedTS.getTime()));
        return worklog;
    }

    Issue getIssueForId(Long issueId) {
        return this.issueManager.getIssueObject(issueId);
    }

    private WorklogManager getWorklogManager() {
        if (this.worklogManager == null) {
            this.worklogManager = ComponentManager.getComponentInstanceOfType(WorklogManager.class);
        }
        return this.worklogManager;
    }
}

