/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IssueOperationsBarUtil {
    private static final String VIEW_ISSUE_OPSBAR = "view.issue.opsbar";
    public static final String EDIT_LINK_ID = "edit-issue";
    private List<SimpleLinkSection> groups;
    private Map<String, List<SimpleLinkSection>> sectionsByGroup = new HashMap<String, List<SimpleLinkSection>>();
    private Map<String, List<SimpleLinkSection>> nonEmptySectionsByGroup = new HashMap<String, List<SimpleLinkSection>>();
    private Map<String, List<SimpleLink>> linksBySection = new HashMap<String, List<SimpleLink>>();
    private Map<String, List<SimpleLink>> promoteLinksByGroup = new HashMap<String, List<SimpleLink>>();
    private final JiraHelper helper;
    private final User user;
    private final SimpleLinkManager simpleLinkManager;
    private final ApplicationProperties applicationProperties;
    private final IssueManager issueManager;
    private final I18nHelper i18n;
    private Integer defaultNumberOfLinksToShow;

    public IssueOperationsBarUtil(JiraHelper helper, User user, SimpleLinkManager simpleLinkManager, ApplicationProperties applicationProperties, IssueManager issueManager, I18nHelper i18n) {
        this.helper = helper;
        this.user = user;
        this.simpleLinkManager = simpleLinkManager;
        this.applicationProperties = applicationProperties;
        this.issueManager = issueManager;
        this.i18n = i18n;
    }

    public List<SimpleLinkSection> getGroups() {
        if (this.groups == null) {
            this.groups = this.simpleLinkManager.getSectionsForLocation(VIEW_ISSUE_OPSBAR, this.user, this.helper);
        }
        return this.groups;
    }

    public List<SimpleLink> getPromotedLinks(SimpleLinkSection group) {
        if (!this.promoteLinksByGroup.containsKey(group.getId())) {
            int numberToShow = this.getRawNumberOfLinksToShow(group);
            ArrayList<SimpleLink> promotedLinks = new ArrayList<SimpleLink>();
            List<SimpleLinkSection> sections = this.getSectionsForGroup(group);
            int conjoinedCount = 0;
            for (SimpleLinkSection section : sections) {
                if (promotedLinks.size() >= numberToShow) continue;
                List<SimpleLink> links = this.getLinksForSection(section);
                for (SimpleLink link : links) {
                    boolean isConjoined;
                    boolean bl = isConjoined = link.getStyleClass() != null && link.getStyleClass().contains("conjoined");
                    if (promotedLinks.size() - conjoinedCount >= numberToShow && (!isConjoined || promotedLinks.size() - conjoinedCount > numberToShow)) continue;
                    if (isConjoined) {
                        ++conjoinedCount;
                    }
                    promotedLinks.add(link);
                }
            }
            this.promoteLinksByGroup.put(group.getId(), promotedLinks);
        }
        return this.promoteLinksByGroup.get(group.getId());
    }

    public List<SimpleLink> getNonPromotedLinksForSection(SimpleLinkSection group, SimpleLinkSection section) {
        List<SimpleLink> links = this.getLinksForSection(section);
        List<SimpleLink> promotedLinks = this.getPromotedLinks(group);
        links.removeAll(promotedLinks);
        return links;
    }

    public List<SimpleLinkSection> getNonEmptySectionsForGroup(SimpleLinkSection group) {
        if (!this.nonEmptySectionsByGroup.containsKey(group.getId())) {
            ArrayList<SimpleLinkSection> returnSections = new ArrayList<SimpleLinkSection>();
            List<SimpleLinkSection> sections = this.getSectionsForGroup(group);
            for (SimpleLinkSection section : sections) {
                List<SimpleLink> links = this.getNonPromotedLinksForSection(group, section);
                if (links.isEmpty()) continue;
                returnSections.add(section);
            }
            this.nonEmptySectionsByGroup.put(group.getId(), returnSections);
        }
        return this.nonEmptySectionsByGroup.get(group.getId());
    }

    public boolean showMoreLinkforGroup(SimpleLinkSection group) {
        return group.getLabel() != null || !this.getNonEmptySectionsForGroup(group).isEmpty();
    }

    private List<SimpleLinkSection> getSectionsForGroup(SimpleLinkSection group) {
        if (!this.sectionsByGroup.containsKey(group.getId())) {
            List sections = this.simpleLinkManager.getSectionsForLocation(group.getId(), this.user, this.helper);
            this.sectionsByGroup.put(group.getId(), sections);
        }
        return this.sectionsByGroup.get(group.getId());
    }

    private List<SimpleLink> getLinksForSection(SimpleLinkSection section) {
        if (!this.linksBySection.containsKey(section.getId())) {
            List sections = this.simpleLinkManager.getLinksForSection(section.getId(), this.user, this.helper);
            Collection filteredSections = Collections2.filter((Collection)sections, (Predicate)new Predicate<SimpleLink>(){

                public boolean apply(@Nullable SimpleLink input) {
                    return !IssueOperationsBarUtil.EDIT_LINK_ID.equals(input.getId());
                }
            });
            this.linksBySection.put(section.getId(), new ArrayList(filteredSections));
        }
        return this.linksBySection.get(section.getId());
    }

    private int getRawNumberOfLinksToShow(SimpleLinkSection group) {
        int i;
        String numberToShow = this.applicationProperties.getDefaultBackedString("ops.bar.group.size." + group.getId().toLowerCase());
        if (StringUtils.isNotBlank((String)numberToShow) && StringUtils.isNumeric((String)numberToShow) && (i = Integer.parseInt(numberToShow)) > 0) {
            return i;
        }
        if (this.defaultNumberOfLinksToShow == null) {
            String defaultNumberOfLinksToShowStr = this.applicationProperties.getDefaultBackedString("ops.bar.group.size");
            if (StringUtils.isNotBlank((String)defaultNumberOfLinksToShowStr) && StringUtils.isNumeric((String)defaultNumberOfLinksToShowStr)) {
                int i2 = Integer.parseInt(defaultNumberOfLinksToShowStr);
                if (i2 > 0) {
                    this.defaultNumberOfLinksToShow = i2;
                    return this.defaultNumberOfLinksToShow;
                }
                return 2;
            }
            this.defaultNumberOfLinksToShow = 2;
        }
        return this.defaultNumberOfLinksToShow;
    }

    public String getLabelForLink(SimpleLink link) {
        return StringUtils.abbreviate((String)link.getLabel(), (int)25);
    }

    public String getTitleForLink(SimpleLink link) {
        String label = link.getLabel();
        String title = link.getTitle();
        if (StringUtils.isBlank((String)title)) {
            if (label.length() > 25) {
                return label;
            }
            return "";
        }
        return title;
    }

    public SimpleLink getEditOrLoginLink(Issue issue) {
        SimpleLink ret = null;
        if (this.showEdit(issue)) {
            ret = this.getEditLink();
        } else if (this.showLogin(issue)) {
            ret = new SimpleLinkImpl("ops-login-lnk", this.i18n.getText("common.concepts.login"), this.i18n.getText("common.concepts.login"), null, null, RedirectUtils.getLinkLoginURL((HttpServletRequest)this.helper.getRequest()), null);
        }
        return ret;
    }

    private boolean showEdit(Issue issue) {
        return this.issueManager.isEditable(issue, this.user);
    }

    private boolean showLogin(Issue issue) {
        if (this.user != null) {
            return false;
        }
        if (this.showEdit(issue)) {
            return false;
        }
        List<SimpleLinkSection> groups = this.getGroups();
        for (SimpleLinkSection group : groups) {
            List<SimpleLink> links = this.getPromotedLinks(group);
            if (links.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private SimpleLink getEditLink() {
        List links = this.simpleLinkManager.getLinksForSection("operations-top-level", this.user, this.helper);
        for (SimpleLink link : links) {
            if (!EDIT_LINK_ID.equals(link.getId())) continue;
            return link;
        }
        return null;
    }
}

