/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.tabpanels.CVSAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CVSCommit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class CVSTabPanel
extends AbstractIssueTabPanel {
    private static final Logger log = Logger.getLogger(CVSTabPanel.class);
    private RepositoryManager repositoryManager;
    private PermissionManager permissionManager;

    public CVSTabPanel(RepositoryManager repositoryManager, PermissionManager permissionManager) {
        this.repositoryManager = repositoryManager;
        this.permissionManager = permissionManager;
    }

    public List<IssueAction> getActions(Issue issue, User remoteUser) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        ArrayList<IssueAction> commitActions = new ArrayList<IssueAction>();
        Map<Long, Set<CVSCommit>> repositoryCommits = this.repositoryManager.getCommits(issue, remoteUser);
        for (Map.Entry<Long, Set<CVSCommit>> entry : repositoryCommits.entrySet()) {
            Long repositoryId = entry.getKey();
            Set<CVSCommit> coms = entry.getValue();
            try {
                Repository repository = this.repositoryManager.getRepository(repositoryId);
                if (coms == null) {
                    commitActions.add((IssueAction)new GenericMessageAction(this.descriptor.getI18nBean().getText("admin.cvsmodules.no.index.error.message", repository.getName())));
                    continue;
                }
                for (CVSCommit cvsCommit : coms) {
                    commitActions.add((IssueAction)new CVSAction(this.descriptor, cvsCommit));
                }
            }
            catch (GenericEntityException e) {
                log.error((Object)("Error retrieving project repository with id: " + repositoryId), (Throwable)e);
            }
        }
        if (commitActions.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nocommits"));
            return CollectionBuilder.newBuilder((Object[])new IssueAction[]{action}).asMutableList();
        }
        Collections.sort(commitActions, IssueActionComparator.COMPARATOR);
        return commitActions;
    }

    public boolean showPanel(Issue issue, User remoteUser) {
        try {
            return this.hasPermission(issue, remoteUser) && !this.repositoryManager.getRepositoriesForProject(issue.getProject()).isEmpty();
        }
        catch (GenericEntityException e) {
            log.error((Object)"Error occurred while retrieving information from the datastore.", (Throwable)e);
            return false;
        }
    }

    private boolean hasPermission(Issue issue, User remoteUser) {
        return this.permissionManager.hasPermission(29, issue, remoteUser);
    }
}

