/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultWorkRatioSearcherInputHelper;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherConfig;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@NonInjectableComponent
public class WorkRatioSearchInputTransformer
implements SearchInputTransformer {
    public static final String MIN_LIMIT_SUFFIX = ":min";
    public static final String MAX_LIMIT_SUFFIX = ":max";
    private final SimpleFieldSearchConstants constants;
    private final WorkRatioSearcherConfig config;
    private final JqlOperandResolver operandResolver;

    public WorkRatioSearchInputTransformer(SimpleFieldSearchConstants constants, WorkRatioSearcherConfig config, JqlOperandResolver operandResolver) {
        this.constants = (SimpleFieldSearchConstants)Assertions.notNull((String)"constants", (Object)constants);
        this.config = (WorkRatioSearcherConfig)Assertions.notNull((String)"config", (Object)config);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
    }

    public void populateFromParams(User searcher, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        Assertions.notNull((String)"actionParams", (Object)actionParams);
        fieldValuesHolder.put((Object)this.getMinField(), (Object)actionParams.getFirstValueForKey(this.getMinField()));
        fieldValuesHolder.put((Object)this.getMaxField(), (Object)actionParams.getFirstValueForKey(this.getMaxField()));
    }

    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        Long minLimit = this.validateRatioField(fieldValuesHolder, this.getMinField(), errors, i18nHelper, "navigator.filter.workratio.min.error");
        Long maxLimit = this.validateRatioField(fieldValuesHolder, this.getMaxField(), errors, i18nHelper, "navigator.filter.workratio.max.error");
        if (minLimit != null && maxLimit != null && minLimit > maxLimit) {
            errors.addError(this.getMinField(), i18nHelper.getText("navigator.filter.workratio.limits.error"));
        }
    }

    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        WorkRatioSearcherInputHelper helper;
        Map<String, String> result;
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        Assertions.notNull((String)"query", (Object)query);
        if (query.getWhereClause() != null && (result = (helper = this.createWorkRatioSearcherInputHelper()).convertClause(query.getWhereClause(), searcher)) != null) {
            fieldValuesHolder.putAll(result);
        }
    }

    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        WorkRatioSearcherInputHelper helper;
        return query == null || query.getWhereClause() == null || (helper = this.createWorkRatioSearcherInputHelper()).convertClause(query.getWhereClause(), searcher) != null;
    }

    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        String minValue = (String)fieldValuesHolder.get((Object)this.config.getMinField());
        String maxValue = (String)fieldValuesHolder.get((Object)this.config.getMaxField());
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
        Clause result = !StringUtils.isBlank((String)minValue) && !StringUtils.isBlank((String)maxValue) ? builder.workRatio().range(minValue, maxValue).buildClause() : (!StringUtils.isBlank((String)minValue) ? builder.workRatio().gtEq(minValue).buildClause() : (!StringUtils.isBlank((String)maxValue) ? builder.workRatio().ltEq(maxValue).buildClause() : null));
        return result;
    }

    WorkRatioSearcherInputHelper createWorkRatioSearcherInputHelper() {
        return new DefaultWorkRatioSearcherInputHelper(this.constants, this.operandResolver);
    }

    private Long validateRatioField(FieldValuesHolder fieldValuesHolder, String fieldId, ErrorCollection errors, I18nHelper i18nHelper, String errorKey) {
        String input = (String)fieldValuesHolder.get((Object)fieldId);
        Long limitValue = null;
        if (StringUtils.isNotEmpty((String)input)) {
            try {
                limitValue = new Long(input);
            }
            catch (NumberFormatException e) {
                errors.addError(fieldId, i18nHelper.getText(errorKey));
            }
        }
        return limitValue;
    }

    private String getMinField() {
        return this.config.getMinField();
    }

    private String getMaxField() {
        return this.config.getMaxField();
    }
}

