/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.fields.option.VersionOption;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractProjectConstantsRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

abstract class AbstractVersionRenderer
extends AbstractProjectConstantsRenderer
implements SearchRenderer {
    private static final Logger log = Logger.getLogger(AbstractVersionRenderer.class);
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final boolean unreleasedOptionsFirst;
    private final SimpleFieldSearchConstantsWithEmpty constants;

    AbstractVersionRenderer(SimpleFieldSearchConstantsWithEmpty constants, String searcherNameKey, ProjectManager projectManager, VersionManager versionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, boolean unreleasedOptionsFirst) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, fieldVisibilityManager, constants, searcherNameKey);
        this.constants = constants;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.unreleasedOptionsFirst = unreleasedOptionsFirst;
    }

    @Override
    List<Option> getSelectListOptions(User searcher, SearchContext searchContext) {
        if (searchContext.isSingleProjectContext()) {
            Long projectId = (Long)searchContext.getProjectIds().iterator().next();
            Project project = this.projectManager.getProjectObj(projectId);
            if (project != null) {
                LinkedList<TextOption> unreleasedOptions = new LinkedList<TextOption>();
                Collection unreleasedVersions = this.versionManager.getVersionsUnreleased(project.getId(), false);
                if (!unreleasedVersions.isEmpty()) {
                    unreleasedOptions.addAll(CollectionUtil.transform((Iterable)unreleasedVersions, VersionOption.FUNCTION));
                    unreleasedOptions.add(0, new TextOption("-2", this.getI18n(searcher).getText("common.filters.unreleasedversions"), "sectionHeaderOption"));
                }
                LinkedList<TextOption> releasedOptions = new LinkedList<TextOption>();
                ArrayList releasedVersions = new ArrayList(this.versionManager.getVersionsReleased(project.getId(), false));
                if (!releasedVersions.isEmpty()) {
                    releasedOptions.addAll(CollectionUtil.transform(releasedVersions, VersionOption.FUNCTION));
                    Collections.reverse(releasedOptions);
                    releasedOptions.add(0, new TextOption("-3", this.getI18n(searcher).getText("common.filters.releasedversions"), "sectionHeaderOption"));
                }
                ArrayList<Option> versions = new ArrayList<Option>();
                if (this.unreleasedOptionsFirst) {
                    versions.addAll(unreleasedOptions);
                    versions.addAll(releasedOptions);
                } else {
                    versions.addAll(releasedOptions);
                    versions.addAll(unreleasedOptions);
                }
                return versions;
            }
            log.warn((Object)("Project for search context " + searchContext + " is invalid"));
        }
        return Collections.emptyList();
    }

    class VersionLabelFunction
    implements Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> {
        private final User searcher;
        private final boolean createBrowseUrl;

        VersionLabelFunction(User searcher, boolean createBrowseUrl) {
            this.searcher = searcher;
            this.createBrowseUrl = createBrowseUrl;
        }

        public AbstractProjectConstantsRenderer.GenericProjectConstantsLabel get(String id) {
            if ("-1".equals(id)) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(AbstractVersionRenderer.this.getI18n(this.searcher).getText("navigator.hidden.search.request.summary.no.versions"));
            }
            if ("-2".equals(id)) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(AbstractVersionRenderer.this.getI18n(this.searcher).getText("navigator.hidden.search.request.summary.all.unreleased.versions"));
            }
            if ("-3".equals(id)) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(AbstractVersionRenderer.this.getI18n(this.searcher).getText("navigator.hidden.search.request.summary.all.released.versions"));
            }
            Version version = AbstractVersionRenderer.this.versionManager.getVersion(new Long(id));
            if (version != null) {
                if (this.createBrowseUrl) {
                    return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(version.getName(), "/browse/" + version.getProjectObject().getKey() + "/fixforversion/" + version.getId());
                }
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(version.getName());
            }
            log.warn((Object)("Unknown " + AbstractVersionRenderer.this.constants.getSearcherId() + " selected. Value: " + id));
            return null;
        }
    }
}

