/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.AbstractLanguageAnalyser;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;

public class EnglishAnalyzer
extends AbstractLanguageAnalyser {
    private final Set<?> stopWords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    private final Version version;

    public EnglishAnalyzer(Version version, boolean indexing) {
        super(indexing);
        this.version = version;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.version, reader);
        result = new StandardFilter(this.version, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.version, (TokenStream)result);
        result = new StopFilter(this.version, (TokenStream)result, this.stopWords);
        result = new PorterStemFilter((TokenStream)result);
        return result;
    }
}

