/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.ReporterRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.ReporterSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.ReporterStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class ReporterSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
RequirableField,
UserField,
RestAwareField,
RestFieldOperations {
    private static final Logger log = Logger.getLogger(ReporterSystemField.class);
    private static final String REPORTER_NAME_KEY = "issue.field.reporter";
    private final ReporterStatisticsMapper reporterStatisticsMapper;
    private UserPickerSearchService searchService;
    private ApplicationProperties applicationProperties;
    private final JiraBaseUrls jiraBaseUrls;
    private final FeatureManager featureManager;
    private final AvatarService avatarService;
    private final UserManager userManager;

    public ReporterSystemField(VelocityTemplatingEngine templatingEngine, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ReporterStatisticsMapper reporterStatisticsMapper, UserPickerSearchService searchService, ReporterSearchHandlerFactory reporterSearchHandlerFactory, JiraBaseUrls jiraBaseUrls, FeatureManager featureManager, AvatarService avatarService, UserManager userManager) {
        super("reporter", REPORTER_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, reporterSearchHandlerFactory);
        this.reporterStatisticsMapper = reporterStatisticsMapper;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.jiraBaseUrls = jiraBaseUrls;
        this.featureManager = featureManager;
        this.avatarService = avatarService;
        this.userManager = userManager;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        JiraServiceContextImpl ctx;
        boolean canPerformAjaxSearch;
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        String reporterName = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put(this.getId(), reporterName);
        velocityParams.put("hasPermissionPickUsers", this.getPermissionManager().hasPermission(27, this.getAuthenticationContext().getLoggedInUser()));
        User reporterUser = this.userManager.getUser(reporterName);
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (reporterUser != null) {
            String avatarUrl = this.avatarService.getAvatarURL(loggedInUser, reporterName, Avatar.Size.SMALL).toString();
            velocityParams.put("reporter", reporterUser.getName());
            velocityParams.put("reporterDisplayName", reporterUser.getDisplayName());
            velocityParams.put("reporterAvatarUrl", avatarUrl);
        }
        if (canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)(ctx = new JiraServiceContextImpl(loggedInUser)))) {
            velocityParams.put("canPerformAjaxSearch", "true");
            velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        String template = this.useFrotherControl() ? "reporter-edit-frother.vm" : "reporter-edit.vm";
        return this.renderTemplate(template, velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("reporter", issue.getReporter());
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("reporter", value);
        return this.getViewHtml(velocityParams);
    }

    private boolean useFrotherControl() {
        return this.featureManager.isEnabled("jira.frother.reporter.field") && !this.featureManager.isEnabled("jira.no.frother.reporter.field");
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("reporter-view.vm", velocityParams);
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 30);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String returnedReporter = (String)fieldValuesHolder.get(this.getId());
        if (TextUtils.stringSet((String)returnedReporter)) {
            User newReporter = UserUtils.getUser((String)returnedReporter);
            if (newReporter == null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.reporter.does.not.exist"));
                return;
            }
            if (!newReporter.isActive() && !returnedReporter.equals(issue.getReporterId())) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.reporter.does.not.exist"));
                return;
            }
        }
        if (fieldScreenRenderLayoutItem.isRequired() && !TextUtils.stringSet((String)returnedReporter)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        }
    }

    public Object getDefaultValue(Issue issue) {
        return this.getAuthenticationContext().getLoggedInUser();
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            User reporter = (User)this.getValueFromParams(fieldValueHolder);
            issue.setReporter(reporter);
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (this.getPermissionManager().hasPermission(11, targetIssue.getProjectObject(), originalIssue.getReporter())) {
                if (originalIssue.getReporter() != null || !targetFieldLayoutItem.isRequired()) continue;
                return new MessagedResult(true);
            }
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        User originalReporter = originalIssue.getReporterUser();
        if (originalReporter != null) {
            fieldValuesHolder.put(this.getId(), originalReporter.getName());
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setReporter(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getReporter() != null;
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                User reporter = (User)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, reporter.getName(), reporter.getDisplayName());
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            User currentReporter = (User)currentValue;
            if (value != null) {
                User reporter = (User)value;
                cib = new ChangeItemBean("jira", this.getId(), currentReporter.getName(), currentReporter.getDisplayName(), reporter.getName(), reporter.getDisplayName());
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentReporter.getName(), currentReporter.getDisplayName(), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    public Object getValueFromParams(Map params) {
        String username = (String)params.get(this.getId());
        if (TextUtils.stringSet((String)username)) {
            return UserUtils.getUser((String)username);
        }
        return null;
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), stringValue);
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        User reporter = issue.getReporterUser();
        if (reporter != null) {
            fieldValuesHolder.put(this.getId(), reporter.getName());
        }
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        User remoteUser = (User)this.getDefaultValue(issue);
        if (remoteUser != null) {
            fieldValuesHolder.put(this.getId(), remoteUser.getName());
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        return null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.reporter";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.reporterStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        try {
            String reporterUserId = issue.getReporterId();
            if (reporterUserId != null) {
                velocityParams.put("reporterUsername", reporterUserId);
            }
        }
        catch (DataAccessException e) {
            log.debug((Object)"Error occurred retrieving reporter", (Throwable)e);
        }
        return this.renderTemplate("reporter-columnview.vm", velocityParams);
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String autoCompleteUrl = String.format("%s/rest/api/latest/user/search?username=", this.jiraBaseUrls.baseUrl());
        return new FieldTypeInfo(null, autoCompleteUrl);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"user", (String)"reporter");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)UserJsonBean.shortBean((User)issue.getReporter(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new ReporterRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        User user = this.getAuthenticationContext().getLoggedInUser();
        if (user == null) {
            return new JsonData(null);
        }
        return new JsonData((Object)UserJsonBean.shortBean((User)user, (JiraBaseUrls)this.jiraBaseUrls));
    }
}

