/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.TextFieldLimitProvider;

public class DefaultTextFieldCharacterLengthValidator
implements TextFieldCharacterLengthValidator {
    static final int UNLIMITED_TEXT_FIELD_CHARACTER_LIMIT = 0;
    private final TextFieldLimitProvider textFieldLimitProvider;

    public DefaultTextFieldCharacterLengthValidator(TextFieldLimitProvider textFieldLimitProvider) {
        this.textFieldLimitProvider = textFieldLimitProvider;
    }

    public boolean isTextTooLong(String text) {
        if (text == null) {
            return false;
        }
        long textFieldCharacterLimit = this.getMaximumNumberOfCharacters();
        if (textFieldCharacterLimit == 0L) {
            return false;
        }
        return (long)text.length() > textFieldCharacterLimit;
    }

    public long getMaximumNumberOfCharacters() {
        return this.textFieldLimitProvider.getTextFieldLimit();
    }
}

