/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LabelsCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Collection<String>> {
    public LabelsCustomFieldOperationsHandler(CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.SET.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    protected Collection<String> handleRemoveOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (!operationValue.isString()) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.operation.must.be.string"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentFieldValue;
        }
        return Collections2.filter(currentFieldValue, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)operationValue.asString())));
    }

    protected Collection<String> handleSetOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operationValue.isNull()) {
            return Collections.emptyList();
        }
        return operationValue.asArrayOfStrings(false, this.field.getId(), errors);
    }

    protected Collection<String> handleAddOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (!operationValue.isString()) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.operation.must.be.string"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentFieldValue;
        }
        ArrayList<String> newList = new ArrayList<String>(currentFieldValue);
        String newLabel = operationValue.asString();
        if (!newList.contains(newLabel)) {
            newList.add(newLabel);
        }
        return newList;
    }

    protected List<String> getInitialCreateValue(IssueContext issueCtx) {
        return Collections.emptyList();
    }

    protected List<String> getInitialValue(Issue issue, ErrorCollection errors) {
        Set fieldValue = (Set)this.field.getValue(issue);
        if (fieldValue == null) {
            return Collections.emptyList();
        }
        Iterable labels = Iterables.transform((Iterable)fieldValue, (Function)new Function<Label, String>(){

            public String apply(Label from) {
                return from.getLabel();
            }
        });
        return Lists.newArrayList((Iterable)labels);
    }

    protected void finaliseOperation(Collection<String> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), finalValue.toArray(new String[finalValue.size()]));
    }
}

