/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.action;

import com.atlassian.jira.issue.comparator.NullComparator;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import java.util.Comparator;
import java.util.Date;

public class IssueActionComparator
implements Comparator<Object> {
    private final NullComparator nullComparator = new NullComparator();
    public static final Comparator<Object> COMPARATOR = new IssueActionComparator();

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof IssueAction && o2 == null) {
            return 1;
        }
        if (o1 == null && o2 instanceof IssueAction) {
            return -1;
        }
        if (o1 instanceof IssueAction && o2 instanceof IssueAction) {
            IssueAction a1 = (IssueAction)o1;
            IssueAction a2 = (IssueAction)o2;
            int returnValue = this.nullComparator.compare(a1, a2);
            if (returnValue != 0) {
                return returnValue;
            }
            Date timePerformed1 = this.getIssueActionTimePerformed(a1);
            Date timePerformed2 = this.getIssueActionTimePerformed(a2);
            return this.nullComparator.compare(timePerformed1, timePerformed2);
        }
        throw new IllegalArgumentException("Can only compare with '" + IssueAction.class.getName() + "'.");
    }

    private Date getIssueActionTimePerformed(IssueAction issueAction) {
        if (issueAction == null) {
            return null;
        }
        try {
            Date date = issueAction.getTimePerformed();
            return date == null ? null : new Date(date.getTime());
        }
        catch (UnsupportedOperationException usoe) {
            return null;
        }
    }
}

