/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalWorklog;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.WorklogParser;
import com.atlassian.jira.util.dbc.Null;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WorklogParserImpl
implements WorklogParser {
    private static final String BODY = "body";
    private static final String CREATED = "created";
    private static final String UPDATED = "updated";
    private static final String STARTDATE = "startdate";
    private static final String AUTHOR = "author";
    private static final String UPDATEAUTHOR = "updateauthor";
    private static final String ROLELEVEL = "rolelevel";
    private static final String GROUPLEVEL = "grouplevel";
    private static final String TIMEWORKED = "timeworked";
    private static final String ID = "id";
    private static final String ISSUE = "issue";

    @Override
    public ExternalWorklog parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String id = (String)attributes.get(ID);
        String issueId = (String)attributes.get(ISSUE);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("A worklog must have an id specified.");
        }
        if (StringUtils.isEmpty((String)issueId)) {
            throw new ParseException("A worklog must have an issue id specified.");
        }
        String body = (String)attributes.get(BODY);
        String created = (String)attributes.get(CREATED);
        String updated = (String)attributes.get(UPDATED);
        String startDate = (String)attributes.get(STARTDATE);
        String author = (String)attributes.get(AUTHOR);
        String updateAuthor = (String)attributes.get(UPDATEAUTHOR);
        String roleLevelIdStr = (String)attributes.get(ROLELEVEL);
        String groupLevel = (String)attributes.get(GROUPLEVEL);
        String timeWorkedStr = (String)attributes.get(TIMEWORKED);
        Long roleLevelId = null;
        Long timeWorked = null;
        if (roleLevelIdStr != null) {
            try {
                roleLevelId = new Long(roleLevelIdStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("The worklog is restricted by a project role with id '" + roleLevelIdStr + "' which is not a valid long.");
            }
        }
        if (timeWorkedStr != null) {
            try {
                timeWorked = new Long(timeWorkedStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("The worklog has a time spent that is not a valid long.");
            }
        }
        ExternalWorklog worklog = new ExternalWorklog();
        worklog.setId(id);
        worklog.setIssueId(issueId);
        worklog.setComment(body);
        worklog.setAuthor(author);
        worklog.setUpdateAuthor(updateAuthor);
        worklog.setGroupLevel(groupLevel);
        worklog.setTimeSpent(timeWorked);
        worklog.setRoleLevelId(roleLevelId);
        if (created != null) {
            worklog.setCreated(Timestamp.valueOf(created));
        }
        if (updated != null) {
            worklog.setUpdated(Timestamp.valueOf(updated));
        }
        if (startDate != null) {
            worklog.setStartDate(Timestamp.valueOf(startDate));
        }
        return worklog;
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalWorklog worklog) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID, worklog.getId());
        attributes.put(ISSUE, worklog.getIssueId());
        attributes.put(BODY, worklog.getComment());
        if (worklog.getCreated() != null) {
            attributes.put(CREATED, new Timestamp(worklog.getCreated().getTime()).toString());
        }
        if (worklog.getUpdated() != null) {
            attributes.put(UPDATED, new Timestamp(worklog.getUpdated().getTime()).toString());
        }
        if (worklog.getStartDate() != null) {
            attributes.put(STARTDATE, new Timestamp(worklog.getStartDate().getTime()).toString());
        }
        attributes.put(AUTHOR, worklog.getAuthor());
        attributes.put(UPDATEAUTHOR, worklog.getUpdateAuthor());
        if (worklog.getTimeSpent() != null) {
            attributes.put(TIMEWORKED, worklog.getTimeSpent().toString());
        }
        if (worklog.getRoleLevelId() != null) {
            attributes.put(ROLELEVEL, worklog.getRoleLevelId().toString());
        }
        if (worklog.getGroupLevel() != null) {
            attributes.put(GROUPLEVEL, worklog.getGroupLevel());
        }
        return new EntityRepresentationImpl("Worklog", attributes);
    }
}

