/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.StatusMapper;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import com.atlassian.jira.imports.project.parser.IssueParser;
import com.atlassian.jira.imports.project.parser.IssueParserImpl;
import java.util.Map;

public class IssueMapperHandler
implements ImportEntityHandler {
    private IssueParser issueParser;
    private final BackupProject backupProject;
    private final IssueTypeMapper issueTypeMapper;
    private final StatusMapper statusMapper;
    private final SimpleProjectImportIdMapper priorityMapper;
    private final SimpleProjectImportIdMapper resolutionMapper;
    private final SimpleProjectImportIdMapper issueSecurityLevelMapper;
    private final UserMapper userMapper;
    private final CustomFieldMapper customFieldMapper;

    public IssueMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        this.backupProject = backupProject;
        this.statusMapper = projectImportMapper.getStatusMapper();
        this.issueTypeMapper = projectImportMapper.getIssueTypeMapper();
        this.priorityMapper = projectImportMapper.getPriorityMapper();
        this.resolutionMapper = projectImportMapper.getResolutionMapper();
        this.issueSecurityLevelMapper = projectImportMapper.getIssueSecurityLevelMapper();
        this.userMapper = projectImportMapper.getUserMapper();
        this.customFieldMapper = projectImportMapper.getCustomFieldMapper();
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        ExternalIssue issue;
        if ("Issue".equals(entityName) && this.backupProject.containsIssue((issue = this.getIssueParser().parse(attributes)).getId())) {
            this.issueTypeMapper.flagValueAsRequired(issue.getIssueType());
            this.statusMapper.flagValueAsRequired(issue.getStatus(), issue.getIssueType());
            this.priorityMapper.flagValueAsRequired(issue.getPriority());
            this.resolutionMapper.flagValueAsRequired(issue.getResolution());
            this.issueSecurityLevelMapper.flagValueAsRequired(issue.getSecurityLevel());
            this.userMapper.flagUserAsMandatory(issue.getAssignee());
            this.userMapper.flagUserAsMandatory(issue.getReporter());
            this.customFieldMapper.flagIssueTypeInUse(issue.getId(), issue.getIssueType());
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    IssueParser getIssueParser() {
        if (this.issueParser == null) {
            this.issueParser = new IssueParserImpl();
        }
        return this.issueParser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueMapperHandler that = (IssueMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.customFieldMapper != null ? !this.customFieldMapper.equals((Object)that.customFieldMapper) : that.customFieldMapper != null) {
            return false;
        }
        if (this.issueParser != null ? !this.issueParser.equals(that.issueParser) : that.issueParser != null) {
            return false;
        }
        if (this.issueSecurityLevelMapper != null ? !this.issueSecurityLevelMapper.equals(that.issueSecurityLevelMapper) : that.issueSecurityLevelMapper != null) {
            return false;
        }
        if (this.issueTypeMapper != null ? !this.issueTypeMapper.equals((Object)that.issueTypeMapper) : that.issueTypeMapper != null) {
            return false;
        }
        if (this.priorityMapper != null ? !this.priorityMapper.equals(that.priorityMapper) : that.priorityMapper != null) {
            return false;
        }
        if (this.resolutionMapper != null ? !this.resolutionMapper.equals(that.resolutionMapper) : that.resolutionMapper != null) {
            return false;
        }
        if (this.statusMapper != null ? !this.statusMapper.equals((Object)that.statusMapper) : that.statusMapper != null) {
            return false;
        }
        return !(this.userMapper != null ? !this.userMapper.equals(that.userMapper) : that.userMapper != null);
    }

    public int hashCode() {
        int result = this.issueParser != null ? this.issueParser.hashCode() : 0;
        result = 31 * result + (this.backupProject != null ? this.backupProject.hashCode() : 0);
        result = 31 * result + (this.issueTypeMapper != null ? this.issueTypeMapper.hashCode() : 0);
        result = 31 * result + (this.statusMapper != null ? this.statusMapper.hashCode() : 0);
        result = 31 * result + (this.priorityMapper != null ? this.priorityMapper.hashCode() : 0);
        result = 31 * result + (this.resolutionMapper != null ? this.resolutionMapper.hashCode() : 0);
        result = 31 * result + (this.issueSecurityLevelMapper != null ? this.issueSecurityLevelMapper.hashCode() : 0);
        result = 31 * result + (this.userMapper != null ? this.userMapper.hashCode() : 0);
        result = 31 * result + (this.customFieldMapper != null ? this.customFieldMapper.hashCode() : 0);
        return result;
    }
}

