/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.imports.project.parser.AttachmentParserImpl;
import com.atlassian.jira.imports.project.transformer.AttachmentTransformer;
import com.atlassian.jira.imports.project.transformer.AttachmentTransformerImpl;
import com.atlassian.jira.issue.attachment.Attachment;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class AttachmentPersisterHandler
extends AbstractPersisterHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(AttachmentPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportOptions projectImportOptions;
    private final ProjectImportMapper projectImportMapper;
    private final BackupProject backupProject;
    private final BackupSystemInformation backupSystemInformation;
    private final ProjectImportResults projectImportResults;
    private AttachmentParser attachmentParser;
    private AttachmentTransformer attachmentTransformer;

    public AttachmentPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportOptions projectImportOptions, ProjectImportMapper projectImportMapper, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportOptions = projectImportOptions;
        this.projectImportMapper = projectImportMapper;
        this.backupProject = backupProject;
        this.backupSystemInformation = backupSystemInformation;
        this.projectImportResults = projectImportResults;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("FileAttachment".equals(entityName) && this.projectImportOptions.getAttachmentPath() != null) {
            final ExternalAttachment externalAttachment = this.getAttachmentParser().parse(attributes);
            if (externalAttachment.getIssueId() != null) {
                final String issueKey = this.backupSystemInformation.getIssueKeyForId(externalAttachment.getIssueId());
                String projectKey = this.backupProject.getProject().getKey();
                String attachmentPath = this.projectImportOptions.getAttachmentPath();
                String issueFileAttachmentPath = this.getAttachmentParser().getFileAttachmentUrl(externalAttachment, attachmentPath, projectKey, issueKey);
                File attachedFile = new File(issueFileAttachmentPath);
                externalAttachment.setAttachedFile(attachedFile);
                if (this.fileExists(attachedFile)) {
                    final ExternalAttachment transformedAttachment = this.getAttachmentTransformer().transform(this.projectImportMapper, externalAttachment);
                    this.execute(new Runnable(){

                        @Override
                        public void run() {
                            Attachment createdAttachment = AttachmentPersisterHandler.this.projectImportPersister.createAttachment(transformedAttachment);
                            if (createdAttachment == null) {
                                AttachmentPersisterHandler.this.projectImportResults.addError(AttachmentPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.attachment.error", externalAttachment.getFileName(), issueKey));
                            } else {
                                AttachmentPersisterHandler.this.projectImportResults.incrementAttachmentsCreatedCount();
                            }
                        }
                    });
                } else {
                    log.warn((Object)("Not saving attachment '" + externalAttachment.getFileName() + "' for issue '" + issueKey + "', the file does not exist in the provided attachment directory."));
                }
            } else {
                log.warn((Object)("Not saving attachment '" + externalAttachment.getFileName() + "' it appears that the issue was not created as part of the import."));
            }
        }
    }

    boolean fileExists(File attachedFile) {
        return attachedFile.exists();
    }

    AttachmentTransformer getAttachmentTransformer() {
        if (this.attachmentTransformer == null) {
            this.attachmentTransformer = new AttachmentTransformerImpl();
        }
        return this.attachmentTransformer;
    }

    AttachmentParser getAttachmentParser() {
        if (this.attachmentParser == null) {
            this.attachmentParser = new AttachmentParserImpl();
        }
        return this.attachmentParser;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }
}

