/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.vote;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DefaultVoteService
implements VoteService {
    private final VoteManager voteManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public DefaultVoteService(VoteManager voteManager, I18nHelper.BeanFactory beanFactory, ApplicationProperties applicationProperties, PermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory) {
        this.voteManager = voteManager;
        this.beanFactory = beanFactory;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
    }

    public VoteService.VoteValidationResult validateAddVote(User remoteUser, User voter, Issue issue) {
        Assertions.notNull((String)"voter", (Object)voter);
        Assertions.notNull((String)"issue", (Object)issue);
        VoteService.VoteValidationResult result = this.validateVoting(remoteUser, voter, issue);
        if (this.voteManager.hasVoted(voter, issue)) {
            I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.error.add.vote.already.voted"));
        }
        return result;
    }

    public int addVote(User remoteUser, VoteService.VoteValidationResult validationResult) {
        Assertions.notNull((String)"remoteUser", (Object)remoteUser);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        this.voteManager.addVote(validationResult.getVoter(), validationResult.getIssue());
        Collection usernames = this.voteManager.getVoterUsernames(validationResult.getIssue());
        return usernames.size();
    }

    public VoteService.VoteValidationResult validateRemoveVote(User remoteUser, User voter, Issue issue) {
        Assertions.notNull((String)"voter", (Object)voter);
        Assertions.notNull((String)"issue", (Object)issue);
        VoteService.VoteValidationResult result = this.validateVoting(remoteUser, voter, issue);
        if (!this.voteManager.hasVoted(voter, issue)) {
            I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.error.remove.vote.not.voted"));
        }
        return result;
    }

    public int removeVote(User remoteUser, VoteService.VoteValidationResult validationResult) {
        Assertions.notNull((String)"remoteUser", (Object)remoteUser);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        this.voteManager.removeVote(validationResult.getVoter(), validationResult.getIssue());
        Collection usernames = this.voteManager.getVoterUsernames(validationResult.getIssue());
        return usernames.size();
    }

    public ServiceOutcome<Collection<User>> viewVoters(Issue issue, User remoteUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(remoteUser);
        if (!this.permissionManager.hasPermission(31, issue.getProjectObject(), remoteUser)) {
            return ServiceOutcomeImpl.error(i18n.getText("voters.no.permission"));
        }
        if (this.voteManager.isVotingEnabled()) {
            List voters = this.voteManager.getVoters(issue, i18n.getLocale());
            return ServiceOutcomeImpl.ok(voters);
        }
        return ServiceOutcomeImpl.error(i18n.getText("issue.operations.voting.disabled"));
    }

    public ServiceOutcome<List<VoteHistoryEntry>> getVoterHistory(Issue issue, User remoteUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(remoteUser);
        if (!this.permissionManager.hasPermission(31, issue.getProjectObject(), remoteUser)) {
            return ServiceOutcomeImpl.error(i18n.getText("voters.no.permission"));
        }
        if (this.voteManager.isVotingEnabled()) {
            return ServiceOutcomeImpl.ok(this.voteManager.getVoteHistory(issue));
        }
        return ServiceOutcomeImpl.error(i18n.getText("issue.operations.voting.disabled"));
    }

    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    public boolean hasVoted(Issue issue, User user) {
        return this.voteManager.hasVoted(user, issue.getGenericValue());
    }

    private VoteService.VoteValidationResult validateVoting(User remoteUser, User voter, Issue issue) {
        String reporterId;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        VoteService.VoteValidationResult result = new VoteService.VoteValidationResult((ErrorCollection)errors, voter, issue);
        if (Users.isAnonymous((User)remoteUser) || Users.isAnonymous((User)voter)) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.voting.not.loggedin"));
        }
        if (!this.permissionManager.hasPermission(10, issue, voter)) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.error.vote.issue.permission"));
        }
        if (StringUtils.isNotBlank((String)(reporterId = issue.getReporterId())) && voter != null && reporterId.equals(voter.getName())) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.novote"));
        }
        if (issue.getResolution() != null) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.voting.resolved"));
        }
        if (!this.applicationProperties.getOption("jira.option.voting")) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.voting.disabled"));
        }
        return result;
    }
}

