/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.validation;

import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import java.util.regex.Pattern;

public class HexColourValidator
implements Validator {
    final Pattern hexColourPattern = Pattern.compile("#[\\da-fA-F]{3,6}");

    @Override
    public Validator.Result validate(String value) {
        if (value == null) {
            return new Failure("Hex colour string cannot be null");
        }
        if (this.hexColourPattern.matcher(value).matches()) {
            return new Success(value);
        }
        return new Failure("String does not appear to match a hex colour string eg. \"#334A5B\"");
    }
}

