/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.web.component.TableLayoutUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TableLayoutUtilsImpl
implements TableLayoutUtils {
    private final ApplicationProperties applicationProperties;
    private final FieldManager fieldManager;
    private static final List<String> defaultCols = new ArrayList<String>();

    public TableLayoutUtilsImpl(ApplicationProperties applicationProperties, FieldManager fieldManager) {
        this.applicationProperties = applicationProperties;
        this.fieldManager = fieldManager;
    }

    public List<String> getDefaultColumnNames(String applicationPropertyName) {
        if (StringUtils.isNotBlank((String)applicationPropertyName)) {
            String[] strings;
            String property = this.applicationProperties.getString(applicationPropertyName);
            if (null == property) {
                property = this.applicationProperties.getDefaultString(applicationPropertyName);
            }
            if (StringUtils.isNotBlank((String)property) && (strings = StringUtils.split((String)property, (String)", ")) != null && strings.length > 0) {
                return Arrays.asList(strings);
            }
        }
        return Collections.unmodifiableList(defaultCols);
    }

    public List<ColumnLayoutItem> getColumns(User user, String applicationPropertyName) throws FieldException {
        List<String> cols = this.getDefaultColumnNames(applicationPropertyName);
        return this.getColumns(user, cols);
    }

    public List<ColumnLayoutItem> getColumns(User user, List<String> fields) throws FieldException {
        Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
        ArrayList<ColumnLayoutItem> columnLayoutItems = new ArrayList<ColumnLayoutItem>();
        if (fields != null) {
            block0: for (String fieldName : fields) {
                for (NavigableField field : availableFields) {
                    if (!fieldName.equals(field.getId())) continue;
                    columnLayoutItems.add(new ColumnLayoutItemImpl(field, columnLayoutItems.size()));
                    continue block0;
                }
            }
        }
        return columnLayoutItems;
    }

    public List<ColumnLayoutItem> getColumns(User user, String context, List<String> columnNames, boolean addDefaults) throws FieldException {
        LinkedHashSet<String> columnNamesToUse = new LinkedHashSet<String>();
        List<String> defaultColumnNames = this.getDefaultColumnNames(context);
        if (columnNames == null || columnNames.isEmpty()) {
            columnNamesToUse.addAll(defaultColumnNames);
        } else {
            if (addDefaults) {
                columnNamesToUse.addAll(defaultColumnNames);
            }
            columnNamesToUse.addAll(columnNames);
        }
        return this.getUserColumns(user, new ArrayList<String>(columnNamesToUse), defaultColumnNames);
    }

    private List<ColumnLayoutItem> getUserColumns(User user, List<String> requestedColumnNames, List<String> defaultColumnNames) throws FieldException {
        List<ColumnLayoutItem> columns = this.getColumns(user, requestedColumnNames);
        if (columns.isEmpty()) {
            columns = this.getColumns(user, defaultColumnNames);
        }
        return columns;
    }

    static {
        defaultCols.add("issuetype");
        defaultCols.add("issuekey");
        defaultCols.add("summary");
        defaultCols.add("priority");
    }
}

