/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserEventDispatcher;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ForgotLoginDetails
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private String username;
    private String email;
    private boolean forgotPassword = false;
    private boolean forgotUserName = false;
    private static final String FORGOT_PASSWORD = "forgotPassword";
    private static final String FORGOT_USER_NAME = "forgotUserName";

    public ForgotLoginDetails(UserUtil userUtil, ApplicationProperties applicationProperties, UserManager userManager) {
        this.userUtil = userUtil;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
    }

    protected String doExecute() throws Exception {
        if (this.isExternalUserManagement() || !this.userManager.hasPasswordWritableDirectory()) {
            throw new IllegalStateException("User login details can not be reset for this JIRA site.");
        }
        if (!this.forgotPassword && !this.forgotUserName) {
            this.forgotPassword = true;
            return "input";
        }
        if (this.forgotPassword) {
            return this.doPassword();
        }
        return this.doUserNames();
    }

    private String doPassword() {
        Map eventParams;
        int userEventType;
        this.doPasswordValidation();
        if (this.invalidInput()) {
            this.email = "";
            return "input";
        }
        User user = this.userUtil.getUser(this.username);
        if (this.userManager.canUpdateUserPassword(user)) {
            userEventType = 2;
            UserUtil.PasswordResetToken passwordResetToken = this.userUtil.generatePasswordResetToken(user);
            eventParams = EasyMap.build((Object)"username", (Object)this.username, (Object)"password.token", (Object)passwordResetToken.getToken(), (Object)"password.hours", (Object)passwordResetToken.getExpiryHours());
        } else {
            userEventType = 4;
            eventParams = EasyMap.build((Object)"username", (Object)this.username);
        }
        UserEventDispatcher.dispatchEvent(userEventType, user, eventParams);
        return "password_success";
    }

    private void doPasswordValidation() {
        if (this.username == null || this.userUtil.getUser(this.username) == null) {
            this.addError("username", this.getText("forgotpassword.error.usernameDoesNotExist"));
        }
    }

    private String doUserNames() {
        this.doUserNamesValidations();
        if (this.invalidInput()) {
            this.username = "";
            return "input";
        }
        List users = UserUtils.getUsersByEmail((String)this.email);
        ArrayList<User> managedUsers = new ArrayList<User>();
        ArrayList<User> unManagedUsers = new ArrayList<User>();
        for (User user : users) {
            if (this.userManager.canUpdateUserPassword(user)) {
                managedUsers.add(user);
                continue;
            }
            unManagedUsers.add(user);
        }
        UserEventDispatcher.dispatchEvent(3, (User)users.get(0), EasyMap.build((Object)"users", (Object)users, (Object)"managedUsers", managedUsers, (Object)"unmanagedUsers", unManagedUsers));
        return "username_success";
    }

    private void doUserNamesValidations() {
        if (UserUtils.getUsersByEmail((String)this.email).isEmpty()) {
            this.addError("email", this.getText("forgotpassword.error.emailaddressDoesNotExist"));
        }
    }

    private boolean isExternalUserManagement() {
        return this.applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    public boolean checked(String id) {
        if (FORGOT_PASSWORD.equals(id)) {
            return this.forgotPassword;
        }
        if (FORGOT_USER_NAME.equals(id)) {
            return this.forgotUserName;
        }
        return false;
    }

    public String displayStyle(String id) {
        if (FORGOT_PASSWORD.equals(id)) {
            return this.forgotPassword ? "" : "display:none";
        }
        if (FORGOT_USER_NAME.equals(id)) {
            return this.forgotUserName ? "" : "display:none";
        }
        return "";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setForgotten(String forgotten) {
        this.forgotPassword = FORGOT_PASSWORD.equals(forgotten);
        this.forgotUserName = FORGOT_USER_NAME.equals(forgotten);
    }
}

