/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.web.action.issue.SearchActionHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import org.apache.log4j.Logger;

public final class SearchActionHelperImpl
implements SearchActionHelper {
    private static final Logger log = Logger.getLogger(SearchActionHelperImpl.class);
    private static final int DEFAULT_NUMBER_OF_ISSUES_PER_PAGE = 20;
    private final JiraAuthenticationContext authContext;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    private final UserPreferencesManager userPreferencesManager;

    public SearchActionHelperImpl(SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory, UserPreferencesManager userPreferencesManager, JiraAuthenticationContext authContext) {
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
        this.userPreferencesManager = userPreferencesManager;
        this.authContext = authContext;
    }

    @Override
    public PagerFilter getPagerFilter() {
        return this.getPagerFilter(null);
    }

    @Override
    public PagerFilter getPagerFilter(Integer tempMax) {
        PagerFilter pager = (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject();
        if (pager == null) {
            pager = this.resetPager();
        }
        if (tempMax != null) {
            pager.setMax(tempMax.intValue());
        }
        return pager;
    }

    @Override
    public PagerFilter resetPager() {
        PagerFilter pager = new PagerFilter();
        try {
            pager.setMax((int)this.getUserPreferences().getLong("user.issues.per.page"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Unable to find 'user.issues.per.page' property setting. Defaulting to 20");
            pager.setMax(20);
        }
        this.getSessionPagerFilterManager().setCurrentObject(pager);
        return pager;
    }

    @Override
    public void resetPagerTempMax() {
        this.resetPagerTempMax(null);
    }

    @Override
    public void resetPagerTempMax(Integer tempMax) {
        if (null != tempMax) {
            this.getPagerFilter(tempMax).setMax(tempMax.intValue());
        }
    }

    private Preferences getUserPreferences() {
        return this.userPreferencesManager.getPreferences(this.authContext.getLoggedInUser());
    }

    private SessionPagerFilterManager getSessionPagerFilterManager() {
        return this.sessionSearchObjectManagerFactory.createPagerFilterManager();
    }
}

