/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.diff.DiffViewBean;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.action.util.DiffViewRenderer;
import com.atlassian.query.order.SearchSort;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import webwork.action.Action;

public class SaveFilter
extends SearchDescriptionEnabledAction
implements FilterOperationsAction {
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final DiffViewRenderer diffViewRenderer;
    private SearchRequest dbSearchRequest;
    private SearchContext dbSearchContext;
    private FieldValuesHolder dbFieldValuesHolder;
    private DiffViewBean wordLevelDiff;

    public SaveFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, DiffViewRenderer diffViewRenderer, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.diffViewRenderer = diffViewRenderer;
    }

    public SaveFilter(SearchRequestService searchRequestService, SearchService searchService, DiffViewRenderer diffViewRenderer, SearchSortUtil searchSortUtil) {
        this(ComponentManager.getComponentInstanceOfType(IssueSearcherManager.class), searchRequestService, searchService, diffViewRenderer, searchSortUtil);
    }

    public String doDefault() throws Exception {
        if (!this.validateSearchRequest()) {
            return "error";
        }
        this.updateDbRequestState();
        return "input";
    }

    protected String doExecute() throws Exception {
        if (!this.validateSearchRequest()) {
            return "error";
        }
        SearchRequest newRequest = this.searchRequestService.updateSearchParameters(this.getJiraServiceContext(), this.getSearchRequest());
        if (newRequest == null || this.hasAnyErrors()) {
            return "error";
        }
        this.setSearchRequest(newRequest);
        return this.getRedirect("IssueNavigator.jspa?mode=hide&requestId=" + this.getSearchRequest().getId());
    }

    public SearchRequest getDbSearchRequest() {
        return this.dbSearchRequest;
    }

    public List<SearchSort> getSearchSorts(SearchRequest searchRequest) {
        if (searchRequest != null && searchRequest.getQuery().getOrderByClause() != null) {
            return searchRequest.getQuery().getOrderByClause().getSearchSorts();
        }
        return Collections.emptyList();
    }

    public boolean isSearchSortsEqual() {
        return ((Object)this.getSearchSorts(this.getSearchRequest())).equals(this.getSearchSorts(this.getDbSearchRequest()));
    }

    public boolean isAdvancedQuery() {
        return !this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), this.dbSearchRequest != null ? this.dbSearchRequest.getQuery() : null) || !this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), this.getSearchRequest() != null ? this.getSearchRequest().getQuery() : null);
    }

    public String getDiffedDbSearchRequestJql() {
        return this.diffViewRenderer.getOriginalHtml(this.getWordLevelDiff());
    }

    public String getDiffedCurrentSearchRequestJql() {
        return this.diffViewRenderer.getRevisedHtml(this.getWordLevelDiff());
    }

    private DiffViewBean getWordLevelDiff() {
        if (this.wordLevelDiff == null) {
            this.wordLevelDiff = DiffViewBean.createWordLevelDiff(this.getDbSearchRequestJql(), this.getCurrentSearchRequestJql());
        }
        return this.wordLevelDiff;
    }

    private String getDbSearchRequestJql() {
        if (this.dbSearchRequest != null) {
            return this.searchService.getJqlString(this.dbSearchRequest.getQuery());
        }
        return "";
    }

    private String getCurrentSearchRequestJql() {
        if (this.getSearchRequest() != null) {
            return this.searchService.getJqlString(this.getSearchRequest().getQuery());
        }
        return "";
    }

    public String getOldSearcherViewHtml(IssueSearcher searcher) {
        SearchRenderer searchRenderer = searcher.getSearchRenderer();
        if (searchRenderer.isRelevantForQuery(this.getLoggedInUser(), this.getDbSearchRequest() != null ? this.getDbSearchRequest().getQuery() : null)) {
            return searchRenderer.getViewHtml(this.getLoggedInUser(), this.dbSearchContext, this.dbFieldValuesHolder, EasyMap.build((Object)"currentFieldValuesHolder", (Object)this.getFieldValuesHolder()), (Action)this);
        }
        return "";
    }

    public String getNewSearcherViewHtml(IssueSearcher searcher) {
        SearchContext searchContext = this.getSearchContext();
        SearchRequest searchRequest = this.getSearchRequest();
        SearchRenderer searchRenderer = searcher.getSearchRenderer();
        if (searchRequest != null && searchRenderer.isRelevantForQuery(this.getLoggedInUser(), searchRequest.getQuery())) {
            return searchRenderer.getViewHtml(this.getLoggedInUser(), searchContext, this.getFieldValuesHolder(), EasyMap.build((Object)"dbFieldValuesHolder", (Object)this.dbFieldValuesHolder), (Action)this);
        }
        return "";
    }

    private void updateDbRequestState() {
        if (this.getSearchRequest() == null || this.getSearchRequest().getId() == null) {
            this.dbSearchRequest = new SearchRequest();
            this.dbSearchRequest.setOwnerUserName(this.getLoggedInUser() == null ? null : this.getLoggedInUser().getName());
        } else {
            this.dbSearchRequest = this.searchRequestService.getFilter(this.getJiraServiceContext(), this.getSearchRequest().getId());
        }
        this.dbFieldValuesHolder = new FieldValuesHolderImpl();
        this.dbSearchContext = this.searchService.getSearchContext(this.getLoggedInUser(), this.dbSearchRequest.getQuery());
        Collection searchers = this.issueSearcherManager.getAllSearchers();
        for (IssueSearcher searcher : searchers) {
            searcher.getSearchInputTransformer().populateFromQuery(this.getLoggedInUser(), this.dbFieldValuesHolder, this.dbSearchRequest.getQuery(), this.dbSearchContext);
        }
    }

    private boolean validateSearchRequest() {
        if (this.getSearchRequest() == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.search.request"));
            return false;
        }
        return this.searchRequestService.validateUpdateSearchParameters(this.getJiraServiceContext(), this.getSearchRequest());
    }
}

