/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.names.WorkflowCopyNameFactory;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class CloneWorkflow
extends JiraWebActionSupport {
    private final JiraWorkflow workflow;
    private final WorkflowService workflowService;
    private final WorkflowCopyNameFactory workflowCopyNameFactory;
    private String description;
    private String newWorkflowName;

    public CloneWorkflow(JiraWorkflow workflow, WorkflowService workflowService, WorkflowCopyNameFactory workflowCopyNameFactory) {
        this.workflow = workflow;
        this.workflowService = workflowService;
        this.workflowCopyNameFactory = workflowCopyNameFactory;
    }

    public String doDefault() throws Exception {
        this.newWorkflowName = this.workflowCopyNameFactory.createFrom(this.getWorkflow().getName(), this.getLocale());
        if (TextUtils.stringSet((String)this.getWorkflow().getDescription())) {
            this.setDescription(this.getWorkflow().getDescription());
        }
        return super.doDefault();
    }

    protected void doValidation() {
        this.workflowService.validateCopyWorkflow(this.getJiraServiceContext(), StringUtils.trim((String)this.newWorkflowName));
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        JiraWorkflow jiraWorkflow = this.workflowService.copyWorkflow(this.getJiraServiceContext(), StringUtils.trim((String)this.newWorkflowName), this.getDescription(), this.getWorkflow());
        if (jiraWorkflow == null || this.hasAnyErrors()) {
            return "error";
        }
        UrlBuilder urlBuilder = new UrlBuilder("EditWorkflowDispatcher.jspa").addParameter("wfName", jiraWorkflow.getName()).addParameter("atl_token", this.getXsrfToken());
        return this.returnCompleteWithInlineRedirect(urlBuilder.asUrlString());
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }
}

