/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.web.action.admin.workflow.AbstractAddWorkflowTransitionDescriptorParams;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import java.util.Map;

@WebSudoRequired
public class AddWorkflowTransitionFunctionParams
extends AbstractAddWorkflowTransitionDescriptorParams {
    private String currentPostFunctionCount;

    public AddWorkflowTransitionFunctionParams(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public AddWorkflowTransitionFunctionParams(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    @Override
    protected Class getWorkflowModuleDescriptorClass() {
        return WorkflowFunctionModuleDescriptor.class;
    }

    @Override
    protected void addWorkflowDescriptor() throws WorkflowException {
        FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        functionDescriptor.setType("class");
        Map functionArgs = functionDescriptor.getArgs();
        functionArgs.put("class.name", this.getDescriptor().getImplementationClass().getName());
        WorkflowFunctionModuleDescriptor functionModuleDescriptor = (WorkflowFunctionModuleDescriptor)this.getDescriptor();
        WorkflowPluginFunctionFactory workflowFunctionFactory = (WorkflowPluginFunctionFactory)functionModuleDescriptor.getModule();
        functionArgs.putAll(workflowFunctionFactory.getDescriptorParams(this.getDescriptorParams()));
        ResultDescriptor unconditionalResult = this.getTransition().getUnconditionalResult();
        if (unconditionalResult == null) {
            unconditionalResult = DescriptorFactory.getFactory().createResultDescriptor();
            this.getTransition().setUnconditionalResult(unconditionalResult);
        }
        List postFunctions = unconditionalResult.getPostFunctions();
        int position = -1;
        if (functionModuleDescriptor.getWeight() != null) {
            for (int i = 0; i < postFunctions.size(); ++i) {
                FunctionDescriptor descriptor = (FunctionDescriptor)postFunctions.get(i);
                if (!descriptor.getType().equals("class") || !descriptor.getArgs().containsKey("class.name")) continue;
                WorkflowFunctionModuleDescriptor workflowModuleDescriptor = null;
                try {
                    Integer weight;
                    workflowModuleDescriptor = this.getWorkflowModuleDescriptor((String)descriptor.getArgs().get("class.name"));
                    if (workflowModuleDescriptor == null || (weight = workflowModuleDescriptor.getWeight()) == null || weight.compareTo(functionModuleDescriptor.getWeight()) <= 0) continue;
                    position = i;
                    break;
                }
                catch (PluginParseException e) {
                    throw new InfrastructureException(e);
                }
            }
            if (position == -1) {
                position = postFunctions.size();
            }
        } else {
            position = 0;
        }
        postFunctions.add(position, functionDescriptor);
        this.currentPostFunctionCount = "" + (position + 1);
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
    }

    @Override
    public String getWorkflowDescriptorName() {
        return "Function";
    }

    @Override
    protected String getRedirectUrl() {
        if (TextUtils.stringSet((String)this.currentPostFunctionCount)) {
            return super.getRedirectUrl() + "&currentCount=workflow-function" + this.currentPostFunctionCount;
        }
        return super.getRedirectUrl();
    }

    protected WorkflowFunctionModuleDescriptor getWorkflowModuleDescriptor(String className) throws PluginParseException {
        List moduleDescriptors = this.getPluginAccessor().getEnabledModuleDescriptorsByType("workflow-function");
        for (WorkflowFunctionModuleDescriptor workflowFunctionModuleDescriptor : moduleDescriptors) {
            if (!workflowFunctionModuleDescriptor.getImplementationClass().getName().equals(className)) continue;
            return workflowFunctionModuleDescriptor;
        }
        return null;
    }
}

