/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.purge;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.web.action.admin.scheme.purge.AbstractSchemePurgeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemePurgeTypePickerAction
extends AbstractSchemePurgeAction {
    public SchemePurgeTypePickerAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
    }

    public String doDefault() throws Exception {
        ActionContext.getSession().remove("__selectedSchemeIdsToDelete");
        this.setSelectedSchemeType("PermissionScheme");
        return "input";
    }

    public void doValidation() {
        if (this.getSelectedSchemeIdsAsList().isEmpty()) {
            this.addErrorMessage(this.getText("admin.scheme.purge.type.picker.action.no.schemes.selected"));
        }
    }

    public String doReturn() throws Exception {
        this.getSelectedSchemeIds();
        ActionContext.getSession().remove("__selectedSchemeIdsToDelete");
        return "input";
    }

    public String doExecute() throws Exception {
        ActionContext.getSession().put("__selectedSchemeIdsToDelete", this.getSelectedSchemeIds());
        return this.forceRedirect("SchemePurgeToolPreview!default.jspa?selectedSchemeType=" + this.getSelectedSchemeType());
    }

    public Map getSchemeTypes() {
        return EasyMap.build((Object)this.getText("admin.scheme.picker.notification.schemes.type"), (Object)"NotificationScheme", (Object)this.getText("admin.scheme.picker.permission.schemes.type"), (Object)"PermissionScheme");
    }

    public List getUnassociatedSchemes(String schemeType) {
        List unassociatedList = this.getSchemeManager(schemeType).getUnassociatedSchemes();
        Iterator iterator = unassociatedList.iterator();
        while (iterator.hasNext()) {
            Scheme scheme = (Scheme)iterator.next();
            Long id = scheme.getId();
            if (scheme.getId() == null || id != 0L) continue;
            iterator.remove();
        }
        return unassociatedList;
    }
}

