/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class AssociateIssueTypeSchemesWithDefault
extends AbstractManageIssueTypeOptionsAction {
    private Long[] projects;
    protected final ProjectManager projectManager;
    private final JiraContextTreeManager treeManager;
    private Collection availableProjects;

    public AssociateIssueTypeSchemesWithDefault(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, ProjectManager projectManager, JiraContextTreeManager treeManager, IssueManager issueManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, issueManager);
        this.projectManager = projectManager;
        this.treeManager = treeManager;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected String doExecute() throws Exception {
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, null, (Long[])this.getProjects(), (JiraContextTreeManager)this.treeManager);
        this.configSchemeManager.removeSchemeAssociation(contexts, this.getConfigurableField());
        this.fieldManager.refresh();
        return this.getRedirect(this.getConfigScheme());
    }

    public Collection getAllProjects() throws Exception {
        if (this.availableProjects == null) {
            ArrayList projects = new ArrayList(this.projectManager.getProjects());
            final FieldConfigScheme defaultIssueTypeScheme = this.issueTypeSchemeManager.getDefaultIssueTypeScheme();
            CollectionUtils.filter(projects, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    GenericValue project = (GenericValue)object;
                    FieldConfigScheme configScheme = AssociateIssueTypeSchemesWithDefault.this.issueTypeSchemeManager.getConfigScheme(project);
                    return !defaultIssueTypeScheme.equals(configScheme);
                }
            });
            this.availableProjects = CollectionUtils.collect(projects, (Transformer)ProjectOption.TRANSFORMER);
        }
        return this.availableProjects;
    }

    public Collection getOptions(FieldConfigScheme configScheme) {
        if (configScheme != null) {
            FieldConfig config = configScheme.getOneAndOnlyConfig();
            return this.optionSetManager.getOptionsForConfig(config).getOptions();
        }
        return Collections.EMPTY_LIST;
    }

    public Long[] getProjects() {
        return this.projects;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public boolean isDefault() {
        return true;
    }

    private Collection getChangedProjectIds() {
        List previousProjects = this.getConfigScheme().getAssociatedProjects();
        List previousProjectIds = previousProjects != null && !previousProjects.isEmpty() ? GenericValueUtils.transformToLongIdsList((Collection)previousProjects) : Collections.EMPTY_LIST;
        List<Long> newProjectIds = this.getProjects() != null && this.getProjects().length > 0 ? Arrays.asList(this.getProjects()) : Collections.EMPTY_LIST;
        Collection affectedProjectIds = CollectionUtils.disjunction((Collection)previousProjectIds, (Collection)newProjectIds);
        return affectedProjectIds;
    }
}

