/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation;

import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.operations.OpInstrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewInstrumentation
extends JiraWebActionSupport {
    private List<InstrumentDisplayBean> displayBeanList;
    private boolean threadContentionMonitoring = false;

    public String doDefault() throws Exception {
        return "success";
    }

    protected String doExecute() throws Exception {
        if (ActionContext.getParameters().get("threadContentionMonitoring") != null) {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            if (threadMXBean.isThreadContentionMonitoringSupported()) {
                threadMXBean.setThreadContentionMonitoringEnabled(this.threadContentionMonitoring);
            }
            if (threadMXBean.isThreadCpuTimeSupported()) {
                threadMXBean.setThreadCpuTimeEnabled(this.threadContentionMonitoring);
            }
        }
        return "success";
    }

    public List<InstrumentDisplayBean> getInstruments() {
        if (this.displayBeanList == null) {
            List<Instrument> instruments = Instrumentation.snapshotInstruments();
            Collections.sort(instruments, new Comparator<Instrument>(){

                @Override
                public int compare(Instrument o1, Instrument o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.displayBeanList = Lists.transform(instruments, (Function)new Function<Instrument, InstrumentDisplayBean>(){

                public InstrumentDisplayBean apply(@Nullable Instrument instrument) {
                    return new InstrumentDisplayBean(instrument);
                }
            });
        }
        return this.displayBeanList;
    }

    public JmxStateInfoDisplayBean getJmxStateInfo() {
        return new JmxStateInfoDisplayBean();
    }

    public void setThreadContentionMonitoring(boolean threadContentionMonitoring) {
        this.threadContentionMonitoring = threadContentionMonitoring;
    }

    public class InstrumentDisplayBean {
        private final Instrument instrument;

        public InstrumentDisplayBean(Instrument instrument) {
            this.instrument = instrument;
        }

        public String getName() {
            return this.instrument.getName();
        }

        public String getType() {
            if (this.instrument instanceof Counter) {
                return ViewInstrumentation.this.getText("admin.instrumentation.instrument.type.counter");
            }
            if (this.instrument instanceof Gauge) {
                return ViewInstrumentation.this.getText("admin.instrumentation.instrument.type.gauge");
            }
            if (this.instrument instanceof OpInstrument) {
                return ViewInstrumentation.this.getText("admin.instrumentation.instrument.type.operation");
            }
            return "Unknown";
        }

        public String getValue() {
            if (this.instrument instanceof OpInstrument) {
                return "";
            }
            return this.valueOf(this.instrument.getValue());
        }

        public String getInvocationCount() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getInvocationCount();
            }
            return this.valueOf(v);
        }

        public String getMillisecondsTaken() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getMillisecondsTaken();
            }
            return this.valueOf(v);
        }

        public String getCpuTime() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getCpuTime();
            }
            return this.valueOf(v);
        }

        public String getResultSetSize() {
            long v = -1L;
            if (this.instrument instanceof OpInstrument) {
                v = ((OpInstrument)this.instrument).getResultSetSize();
            }
            return this.valueOf(v);
        }

        private String valueOf(long v) {
            if (v == -1L) {
                return "";
            }
            NumberFormat df = DecimalFormat.getNumberInstance(ViewInstrumentation.this.getLocale());
            return df.format(v);
        }
    }

    public class JmxStateInfoDisplayBean {
        public boolean isThreadContentionMonitoringSupported() {
            return ManagementFactory.getThreadMXBean().isThreadContentionMonitoringSupported();
        }

        public boolean isThreadContentionMonitoringEnabled() {
            return ManagementFactory.getThreadMXBean().isThreadContentionMonitoringEnabled();
        }

        public boolean isThreadCpuTimeSupported() {
            return ManagementFactory.getThreadMXBean().isThreadCpuTimeSupported();
        }

        public boolean isThreadCpuTimeEnabled() {
            return ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled();
        }
    }
}

