/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.ViewAttachmentSettings;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.io.File;

@WebSudoRequired
public class EditAttachmentSettings
extends ViewAttachmentSettings {
    private boolean thumbnailsEnabled;
    private boolean zipSupport;
    private String attachmentPath;
    private String customAttachmentPath;
    private String attachmentSize;
    private final AttachmentPathManager attachmentPathManager;
    private AttachmentPathManager.Mode attachmentMode;

    public EditAttachmentSettings(AttachmentPathManager attachmentPathManager) {
        this(ManagerFactory.getProjectManager(), ManagerFactory.getPermissionManager(), attachmentPathManager);
    }

    public EditAttachmentSettings(ProjectManager projectManager, PermissionManager permissionManager, AttachmentPathManager attachmentPathManager) {
        super(projectManager, permissionManager, attachmentPathManager);
        this.attachmentPathManager = attachmentPathManager;
    }

    public String doDefault() throws Exception {
        this.setAttachmentPathVariables(this.attachmentPathManager.getMode());
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        this.attachmentSize = applicationProperties.getDefaultBackedString("webwork.multipart.maxSize");
        this.thumbnailsEnabled = applicationProperties.getOption("jira.option.allowthumbnails");
        this.zipSupport = applicationProperties.getOption("jira.attachment.allow.zip.support");
        return "input";
    }

    private void setAttachmentPathVariables(AttachmentPathManager.Mode mode) {
        this.attachmentMode = mode;
        this.customAttachmentPath = null;
        if (this.attachmentMode == AttachmentPathManager.Mode.CUSTOM) {
            this.customAttachmentPath = this.attachmentPath = this.attachmentPathManager.getAttachmentPath();
        } else {
            this.attachmentPath = this.attachmentPathManager.getDefaultAttachmentPath();
        }
    }

    protected void doValidation() {
        this.setAttachmentPathVariables(this.attachmentMode);
        if (!this.isSystemAdministrator()) {
            this.attachmentMode = this.attachmentPathManager.getMode();
        }
        if (this.attachmentMode == AttachmentPathManager.Mode.DEFAULT) {
            File actualPath = new File(this.attachmentPathManager.getDefaultAttachmentPath());
            this.tryToCreateAttachmentPath(actualPath);
            if (!actualPath.exists() || !actualPath.isDirectory()) {
                this.addError("attachmentPath", this.getText("admin.errors.path.entered.does.not.exist"));
            } else if (!actualPath.canRead() || !actualPath.canWrite()) {
                this.addError("attachmentPath", this.getText("admin.errors.path.entered.is.not.readable"));
            }
            if (!TextUtils.stringSet((String)this.attachmentSize)) {
                this.addError("attachmentSize", this.getText("admin.errors.attachments.size.required"));
            } else {
                try {
                    int maxSize = Integer.parseInt(this.attachmentSize);
                    if (maxSize <= 0) {
                        this.addError("attachmentSize", this.getText("admin.errors.attachments.size.must.be.positive"));
                    }
                }
                catch (NumberFormatException e) {
                    this.addError("attachmentSize", this.getText("admin.errors.attachments.size.must.be.between", String.valueOf(Integer.MAX_VALUE)));
                }
            }
        } else if (this.attachmentMode == AttachmentPathManager.Mode.DISABLED) {
            if (this.thumbnailsEnabled) {
                this.addErrorMessage(this.getText("admin.errors.attachments.must.be.enabled.to.enable.thumbnails"));
            }
            if (this.zipSupport) {
                this.addErrorMessage(this.getText("admin.errors.attachments.must.be.enabled.to.enable.zip.support"));
            }
        }
        super.doValidation();
    }

    private void tryToCreateAttachmentPath(File actualPath) {
        if (!actualPath.exists()) {
            actualPath.mkdirs();
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        if (this.isSystemAdministrator()) {
            if (this.attachmentMode == AttachmentPathManager.Mode.DEFAULT) {
                this.attachmentPathManager.setUseDefaultDirectory();
                applicationProperties.setOption("jira.option.allowattachments", true);
            } else if (this.attachmentMode == AttachmentPathManager.Mode.DISABLED) {
                this.attachmentPathManager.disableAttachments();
            }
        }
        if (this.attachmentMode == AttachmentPathManager.Mode.DISABLED) {
            this.thumbnailsEnabled = false;
        }
        applicationProperties.setOption("jira.option.allowthumbnails", this.thumbnailsEnabled);
        applicationProperties.setOption("jira.attachment.allow.zip.support", this.zipSupport);
        if (this.attachmentMode != AttachmentPathManager.Mode.DISABLED) {
            applicationProperties.setString("webwork.multipart.maxSize", this.attachmentSize);
        }
        return this.returnComplete("ViewAttachmentSettings.jspa");
    }

    public String getDefaultAttachmentPath() {
        return this.attachmentPathManager.getDefaultAttachmentPath();
    }

    @Override
    public String getAttachmentPath() {
        return this.attachmentPath;
    }

    public String getAttachmentSize() {
        if (this.attachmentSize == null) {
            this.attachmentSize = this.getApplicationProperties().getDefaultBackedString("webwork.multipart.maxSize");
        }
        return this.attachmentSize;
    }

    public String getAttachmentPathOption() {
        return this.attachmentMode.toString();
    }

    public void setAttachmentPathOption(String attachmentPathOption) {
        this.attachmentMode = AttachmentPathManager.Mode.valueOf((String)attachmentPathOption);
    }

    public boolean isThumbnailsEnabled() {
        return this.thumbnailsEnabled;
    }

    public void setThumbnailsEnabled(boolean thumbnailsEnabled) {
        this.thumbnailsEnabled = thumbnailsEnabled;
    }

    public void setAttachmentSize(String attachmentSize) {
        this.attachmentSize = attachmentSize;
    }

    public boolean isZipSupport() {
        return this.zipSupport;
    }

    public void setZipSupport(boolean zipSupport) {
        this.zipSupport = zipSupport;
    }

    public String getCustomAttachmentPath() {
        return this.customAttachmentPath;
    }
}

