/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ParameterStore {
    private User user;
    private List<TextOption> timePeriods;
    private List<Map<String, String>> reporterTypes;
    private List<Map<String, String>> assigneeTypes;
    private I18nHelper i18n;

    public ParameterStore(User user) {
        this.user = user;
        this.i18n = new I18nBean(user);
    }

    public ParameterStore(String userName) {
        this(UserUtils.getUser((String)userName));
    }

    public Collection<TextOption> getTimePeriods() {
        if (this.timePeriods == null) {
            this.setTimePeriods();
        }
        return this.timePeriods;
    }

    private void setTimePeriods() {
        this.timePeriods = Lists.newArrayList((Object[])new TextOption[]{new TextOption("-1h", this.i18n.getText("time.periods.hour")), new TextOption("-1d", this.i18n.getText("time.periods.day")), new TextOption("-1w", this.i18n.getText("time.periods.week")), new TextOption("-4w 2d", this.i18n.getText("time.periods.month"))});
    }

    public List<Map<String, String>> getReporterTypes() {
        if (this.reporterTypes == null) {
            this.setReporterTypes();
        }
        return this.reporterTypes;
    }

    private void setReporterTypes() {
        this.reporterTypes = new ArrayList<Map<String, String>>();
        this.reporterTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("reporter.types.anyuser")).add((Object)"key", (Object)"").add((Object)"related", (Object)"select.list.none").toImmutableMap());
        this.reporterTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("reporter.types.noreporter")).add((Object)"key", (Object)"issue_no_reporter").add((Object)"related", (Object)"select.list.none").toImmutableMap());
        if (this.user != null) {
            this.reporterTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("reporter.types.currentuser")).add((Object)"key", (Object)"issue_current_user").add((Object)"related", (Object)"select.list.none").toImmutableMap());
        }
        this.reporterTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("reporter.types.specifyuser")).add((Object)"key", (Object)"specificuser").add((Object)"related", (Object)"select.list.user").toImmutableMap());
        this.reporterTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("reporter.types.specifygroup")).add((Object)"key", (Object)"specificgroup").add((Object)"related", (Object)"select.list.group").toImmutableMap());
    }

    public List<Map<String, String>> getAssigneeTypes() {
        if (this.assigneeTypes == null) {
            this.setAsssigneeTypes();
        }
        return this.assigneeTypes;
    }

    private void setAsssigneeTypes() {
        this.assigneeTypes = new ArrayList<Map<String, String>>();
        this.assigneeTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("assignee.types.anyuser")).add((Object)"key", null).add((Object)"related", (Object)"select.list.none").toImmutableMap());
        this.assigneeTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("assignee.types.unassigned")).add((Object)"key", (Object)"unassigned").add((Object)"related", (Object)"select.list.none").toImmutableMap());
        if (this.user != null) {
            this.assigneeTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("assignee.types.currentuser")).add((Object)"key", (Object)"issue_current_user").add((Object)"related", (Object)"select.list.none").toImmutableMap());
        }
        this.assigneeTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("assignee.types.specifyuser")).add((Object)"key", (Object)"specificuser").add((Object)"related", (Object)"select.list.user").toImmutableMap());
        this.assigneeTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("assignee.types.specifygroup")).add((Object)"key", (Object)"specificgroup").add((Object)"related", (Object)"select.list.group").toImmutableMap());
    }
}

