/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.upgrade.tasks.jql.AbstractSimpleClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.clause.Clause;
import electric.xml.Element;
import java.util.List;

public class MultiValueParameterClauseXmlHandler
extends AbstractSimpleClauseXmlHandler
implements ClauseXmlHandler {
    private static final String MULTI_KEY_SEARCHER_ELEMENT_NAME = "key";
    private static final String MULTI_KEY_TYPE_KEY = "com.atlassian.jira.toolkit:multikeyfield";
    private final CustomFieldManager customFieldManager;

    public MultiValueParameterClauseXmlHandler(FieldFlagOperandRegistry fieldFlagOperandRegistry, CustomFieldManager customFieldManager) {
        super(fieldFlagOperandRegistry);
        this.customFieldManager = customFieldManager;
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String xmlFieldId = el.getName();
        if (MULTI_KEY_SEARCHER_ELEMENT_NAME.equalsIgnoreCase(xmlFieldId)) {
            List customFields = this.customFieldManager.getCustomFieldObjects();
            for (CustomField customField : customFields) {
                if (!MULTI_KEY_TYPE_KEY.equalsIgnoreCase(customField.getCustomFieldType().getKey())) continue;
                xmlFieldId = customField.getId();
                return super.convertXmlToClause(el, xmlFieldId);
            }
            ClauseXmlHandler.ConversionResult conversionResult = super.convertXmlToClause(el);
            if (ClauseXmlHandler.ConversionResultType.FULL_CONVERSION == conversionResult.getResultType()) {
                Clause clause = conversionResult.getClause();
                conversionResult = new ClauseXmlHandler.BestGuessConversionResult(clause, xmlFieldId, clause.getName());
            }
            return conversionResult;
        }
        return super.convertXmlToClause(el);
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }

    @Override
    protected boolean xmlFieldIdSupported(String xmlFieldId) {
        return true;
    }
}

