/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build257
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build257.class);
    private OfBizDelegator ofBizDelegator;
    private EventTypeManager eventTypeManager;
    static final String ISSUE_WORKLOG_UPDATED_NAME_KEY = "event.type.issueworklogupdated.name";
    static final String ISSUE_WORKLOG_UPDATED_DESC_KEY = "event.type.issueworklogupdated.desc";
    static final String ISSUE_WORKLOG_DELETED_NAME_KEY = "event.type.issueworklogdeleted.name";
    static final String ISSUE_WORKLOG_DELETED_DESC_KEY = "event.type.issueworklogdeleted.desc";
    static final String ISSUE_WORKLOG_UPDATED_NAME = "Issue Worklog Updated";
    static final String ISSUE_WORKLOG_UPDATED_DESC = "This is the 'Issue Worklog Updated' event type.";
    static final String ISSUE_WORKLOG_DELETED_NAME = "Issue Worklog Deleted";
    static final String ISSUE_WORKLOG_DELETED_DESC = "This is the 'Issue Worklog Deleted' event type.";

    public UpgradeTask_Build257(OfBizDelegator ofBizDelegator, EventTypeManager eventTypeManager) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public String getShortDescription() {
        return "Creates the EventTypes for the ISSUE_WORKLOG_UPDATED and ISSUE_WORKLOG_DELETED events.";
    }

    @Override
    public String getBuildNumber() {
        return "257";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws DataAccessException {
        Map eventTypeParamasMap;
        GenericValue value;
        try {
            value = this.ofBizDelegator.findByPrimaryKey("EventType", EasyMap.build((Object)"id", (Object)EventType.ISSUE_WORKLOG_UPDATED_ID));
            if (value == null) {
                eventTypeParamasMap = EasyMap.build((Object)"id", (Object)EventType.ISSUE_WORKLOG_UPDATED_ID, (Object)"name", (Object)this.getI18nTextWithDefault(ISSUE_WORKLOG_UPDATED_NAME_KEY, ISSUE_WORKLOG_UPDATED_NAME), (Object)"description", (Object)this.getI18nTextWithDefault(ISSUE_WORKLOG_UPDATED_DESC_KEY, ISSUE_WORKLOG_UPDATED_DESC), (Object)"type", (Object)"jira.system.event.type");
                this.ofBizDelegator.createValue("EventType", eventTypeParamasMap);
            } else {
                log.warn((Object)"Not creating 'Worklog Updated' event as it already exists.  This should only happen if this upgrade task is run twice.");
            }
        }
        catch (DataAccessException e) {
            log.error((Object)"JIRA was unable to create the new notification event type of 'Issue Worklog Updated' with an id of 15.");
            throw e;
        }
        try {
            value = this.ofBizDelegator.findByPrimaryKey("EventType", EasyMap.build((Object)"id", (Object)EventType.ISSUE_WORKLOG_DELETED_ID));
            if (value == null) {
                eventTypeParamasMap = EasyMap.build((Object)"id", (Object)EventType.ISSUE_WORKLOG_DELETED_ID, (Object)"name", (Object)this.getI18nTextWithDefault(ISSUE_WORKLOG_DELETED_NAME_KEY, ISSUE_WORKLOG_DELETED_NAME), (Object)"description", (Object)this.getI18nTextWithDefault(ISSUE_WORKLOG_DELETED_DESC_KEY, ISSUE_WORKLOG_DELETED_DESC), (Object)"type", (Object)"jira.system.event.type");
                this.ofBizDelegator.createValue("EventType", eventTypeParamasMap);
            } else {
                log.warn((Object)"Not creating 'Worklog Deleted' event as it already exists.  This should only happen if this upgrade task is run twice.");
            }
        }
        catch (DataAccessException e) {
            log.error((Object)"JIRA was unable to create the new notification event type of 'Issue Worklog Deleted' with an id of 16.");
            throw e;
        }
        this.eventTypeManager.clearCache();
    }

    private String getI18nTextWithDefault(String key, String defaultResult) {
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }
}

