/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;

public abstract class AbstractUpgradeTask
implements UpgradeTask {
    private final boolean reindexRequired;
    private final List<String> errors = new ArrayList<String>();

    protected AbstractUpgradeTask(boolean reindexRequired) {
        this.reindexRequired = reindexRequired;
    }

    @Override
    public boolean isReindexRequired() {
        return this.reindexRequired;
    }

    @Override
    public abstract String getBuildNumber();

    @Override
    public abstract void doUpgrade(boolean var1) throws Exception;

    @Override
    public String getShortDescription() {
        return "Upgrade to build number: " + this.getBuildNumber();
    }

    @Deprecated
    protected GenericDelegator getDelegator() {
        return CoreFactory.getGenericDelegator();
    }

    protected static OfBizDelegator getOfBizDelegator() {
        return ComponentAccessor.getOfBizDelegator();
    }

    protected ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    protected void addError(String error) {
        this.errors.add(error);
    }

    public void addErrors(String prefix, Collection<String> errors) {
        for (String errorMessage : errors) {
            errors.add(prefix + errorMessage);
        }
    }

    public void addErrors(Collection<String> errors) {
        this.addErrors("", errors);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    protected Connection getDatabaseConnection() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            DatabaseUtil utils = new DatabaseUtil(helper.getHelperName());
            return utils.getConnection();
        }
        catch (SQLException e) {
            throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
        }
    }

    protected String convertToSchemaTableName(String tableName) {
        GenericHelper helper = null;
        try {
            helper = this.getDelegator().getEntityHelper("User");
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helper.getHelperName());
        return AbstractUpgradeTask.ensureTablePrefixed(tableName, datasourceInfo.getSchemaName());
    }

    static String ensureTablePrefixed(String tableName, String schemaName) {
        String prefix;
        if (StringUtils.isNotBlank((String)schemaName) && !tableName.startsWith(prefix = schemaName + ".")) {
            return prefix + tableName;
        }
        return tableName;
    }
}

