/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfig;
import java.security.Principal;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class JiraRoleMapper
implements RoleMapper {
    private static final Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;

    public boolean hasRole(Principal user, HttpServletRequest request, String role) {
        int permissionType = Permissions.getType((String)role);
        if (permissionType == -1) {
            throw new IllegalArgumentException("Unknown role '" + role + "'");
        }
        boolean hasRole = this.getPermissionManager().hasPermission(permissionType, (User)user);
        if (!hasRole) {
            String userName = user == null ? "anonymous" : user.getName();
            loggerSecurityEvents.warn((Object)("The user '" + userName + "' is NOT AUTHORIZED to perform this request"));
        }
        return hasRole;
    }

    public boolean canLogin(@Nullable Principal user, HttpServletRequest request) {
        if (user != null) {
            boolean canLogin = this.getLoginManager().authorise((User)user, request);
            if (!canLogin) {
                loggerSecurityEvents.warn((Object)("The user '" + user.getName() + "' is NOT AUTHORIZED to perform to login for this request"));
            }
            return canLogin;
        }
        return false;
    }

    public void init(Map map, SecurityConfig securityConfig) {
    }

    LoginManager getLoginManager() {
        return ComponentManager.getComponentInstanceOfType(LoginManager.class);
    }

    PermissionManager getPermissionManager() {
        return ComponentManager.getComponentInstanceOfType(PermissionManager.class);
    }
}

