/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.plugin.componentpanel.fragment.ComponentTabPanelFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class DueVersionsFragment
extends AbstractFragment
implements ComponentTabPanelFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/";
    private static final int DEFAULT_DISPLAY_VERSION_COUNT = 5;
    private static final int MAX_DISPLAY_VERSION_COUNT = 50;
    private final VersionManager versionManager;

    public DueVersionsFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext jiraAuthenticationContext, VersionManager versionManager) {
        super(templatingEngine, jiraAuthenticationContext);
        this.versionManager = versionManager;
    }

    @Override
    public String getId() {
        return "dueversions";
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        Collection<Version> versions = this.getVersions(ctx);
        int moreVersionsCount = 0;
        if (versions.size() > 50) {
            moreVersionsCount = versions.size() - 50;
            versions = new ArrayList<Version>(versions).subList(0, 50);
        }
        velocityParams.put("versions", versions);
        velocityParams.put("moreVersionsCount", moreVersionsCount);
        velocityParams.put("defaultDisplayCount", 5);
        velocityParams.put("SFM_HIDE", OutlookDate.SmartFormatterModes.HIDE_TIME);
        return velocityParams;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return this.isFixForVersionsFieldVisible(ctx) && !this.getVersions(ctx).isEmpty();
    }

    private Collection<Version> getVersions(BrowseContext ctx) {
        return this.versionManager.getVersionsUnreleased(ctx.getProject().getId(), false);
    }

    private boolean isFixForVersionsFieldVisible(BrowseContext ctx) {
        FieldVisibilityBean visibility = new FieldVisibilityBean();
        return !visibility.isFieldHiddenInAllSchemes(ctx.getProject().getId(), "fixVersions");
    }
}

