/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.JiraEntityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericValue;

public class ProjectRoleSecurityAndNotificationType
extends AbstractProjectsSecurityType
implements NotificationType,
SecurityType {
    public static final String PROJECT_ROLE = "projectrole";
    private static final Logger log = Logger.getLogger(ProjectRoleSecurityAndNotificationType.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectFactory projectFactory;

    public ProjectRoleSecurityAndNotificationType(JiraAuthenticationContext jiraAuthenticationContext, ProjectRoleManager projectRoleManager, ProjectFactory projectFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRoleManager = projectRoleManager;
        this.projectFactory = projectFactory;
    }

    @Override
    public Query getQuery(User searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        TermQuery issueLevelQuery = new TermQuery(new Term("issue_security_level", securityLevel.getId().toString()));
        TermQuery projectQuery = new TermQuery(new Term("projid", project.getId().toString()));
        BooleanQuery query = new BooleanQuery();
        query.add((Query)issueLevelQuery, BooleanClause.Occur.MUST);
        query.add((Query)projectQuery, BooleanClause.Occur.MUST);
        return query;
    }

    public Collection getProjectRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notifications.projectrole");
    }

    @Override
    public String getType() {
        return PROJECT_ROLE;
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
        if (!this.doValidation(key, parameters)) {
            String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.project.role");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        }
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        boolean validParam = false;
        Object value = parameters.get(key);
        if (StringUtils.isNotBlank((String)((String)value))) {
            Long roleId = new Long((String)value);
            for (ProjectRole projectRole : this.getProjectRoles()) {
                if (!roleId.equals(projectRole.getId())) continue;
                return true;
            }
        }
        return validParam;
    }

    @Override
    public String getArgumentDisplay(String roleTypeId) {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(new Long(roleTypeId));
        return projectRole.getName();
    }

    @Override
    public Set<User> getUsers(PermissionContext permissionContext, String roleId) {
        GenericValue projectGv = permissionContext.getProject();
        if (projectGv != null) {
            Project project = this.projectFactory.getProject(projectGv);
            return this.getUsersFromRole(project, roleId);
        }
        log.warn((Object)"returning no users because project in the permission context was null");
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument, User user, boolean issueCreation) {
        GenericValue projectGv = JiraEntityUtils.getProject(entity);
        if (projectGv != null) {
            Project project = this.projectFactory.getProject(projectGv);
            ProjectRoleActors projectRoleActors = this.getProjectRoleActors(argument, project);
            return projectRoleActors.contains(user);
        }
        log.warn((Object)"falling back to no permission because project in the permission context was null");
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument, User user, boolean issueCreation) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null");
        }
        ProjectRoleActors projectRoleActors = this.getProjectRoleActors(argument, project);
        return projectRoleActors.contains(user);
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, User user, boolean issueCreation) {
        return this.hasPermission(issue.getProjectObject(), parameter, user, issueCreation);
    }

    public List getRecipients(IssueEvent event, String roleId) {
        Project project = event.getIssue().getProjectObject();
        if (project == null) {
            return Collections.EMPTY_LIST;
        }
        Set recipients = this.getUsersFromRole(project, roleId);
        ArrayList<NotificationRecipient> notificationRecipients = new ArrayList<NotificationRecipient>();
        for (User recipient : recipients) {
            notificationRecipients.add(new NotificationRecipient(recipient));
        }
        return notificationRecipients;
    }

    protected Set getUsersFromRole(Project project, String roleId) {
        Set users;
        try {
            ProjectRoleActors projectRoleActors = this.getProjectRoleActors(roleId, project);
            users = projectRoleActors.getUsers();
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Could not resolve project role actors for the provided roleId and project", (Throwable)e);
            users = Collections.EMPTY_SET;
        }
        return users;
    }

    private ProjectRoleActors getProjectRoleActors(String roleId, Project project) {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(new Long(roleId));
        return this.projectRoleManager.getProjectRoleActors(projectRole, project);
    }
}

