/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.projectroles;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.jelly.tag.projectroles.ProjectRoleTagSupport;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.ofbiz.core.entity.GenericValue;

public class DeleteProjectRole
extends ProjectRoleTagSupport {
    private static final String KEY_PROJECTROLE_CONFIRM_FLAG = "confirm";

    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRoleService projectRoleService = ComponentManager.getComponentInstanceOfType(ProjectRoleService.class);
        ProjectRole projectRole = this.getProjectRole(errorCollection);
        boolean confirm = this.getConfirmFlag();
        if (!confirm) {
            this.checkIfRoleHasAssociations(this.getUser(), projectRole, errorCollection, projectRoleService);
        }
        projectRoleService.deleteProjectRole(this.getUser(), projectRole, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            throw new JellyTagException(errorCollection.toString());
        }
        this.invokeBody(xmlOutput);
    }

    private boolean getConfirmFlag() {
        String confirmFlag = (String)this.getProperties().get(KEY_PROJECTROLE_CONFIRM_FLAG);
        return Boolean.valueOf(confirmFlag);
    }

    private void checkIfRoleHasAssociations(User currentUser, ProjectRole projectRole, SimpleErrorCollection errorCollection, ProjectRoleService projectRoleService) {
        ArrayList associatedSchemes = new ArrayList();
        associatedSchemes.addAll(projectRoleService.getAssociatedNotificationSchemes(currentUser, projectRole, (ErrorCollection)errorCollection));
        associatedSchemes.addAll(projectRoleService.getAssociatedPermissionSchemes(currentUser, projectRole, (ErrorCollection)errorCollection));
        StringBuilder message = new StringBuilder(32);
        if (!associatedSchemes.isEmpty()) {
            message.append("Project Role: ").append(projectRole.getName());
            message.append(" is associated with the following scheme(s): ");
            Iterator iterator = associatedSchemes.iterator();
            while (iterator.hasNext()) {
                GenericValue scheme = (GenericValue)iterator.next();
                message.append(scheme.getString("name"));
                if (!iterator.hasNext()) continue;
                message.append(", ");
            }
            message.append(".");
        }
        message.append("To force deletion of this role make the confirm parameter 'true'.");
        errorCollection.addErrorMessage(message.toString());
    }
}

