/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.project;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.PermissionSchemeAware;
import com.atlassian.jira.jelly.tag.ProjectAwareActionTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AssignPermissionScheme
extends ProjectAwareActionTagSupport
implements PermissionSchemeAware {
    private static final transient Logger log = Logger.getLogger(AssignPermissionScheme.class);
    private static final String KEY_SCHEME_ID_LIST = "schemeIds";
    private static final String KEY_PROJECT_ID = "projectId";

    public AssignPermissionScheme() {
        this.setActionName("SelectProjectScheme");
    }

    @Override
    public String[] getRequiredContextVariables() {
        String[] result = new String[super.getRequiredContextVariables().length + 1];
        System.arraycopy(super.getRequiredContextVariables(), 0, result, 0, super.getRequiredContextVariables().length);
        result[result.length - 1] = "jelly.permission.scheme.id";
        return result;
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        this.setProperty(KEY_PROJECT_ID, this.getProjectId().toString());
        this.setProperty(KEY_SCHEME_ID_LIST, this.getPermissionSchemeId().toString());
    }

    @Override
    public boolean hasPermissionScheme() {
        return this.getContext().getVariables().containsKey("jelly.permission.scheme.id");
    }

    @Override
    public Long getPermissionSchemeId() {
        String permissionSchemeIdStr = (String)this.getContext().getVariable("jelly.permission.scheme.id");
        try {
            return new Long(permissionSchemeIdStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public GenericValue getPermissionScheme() {
        try {
            return ManagerFactory.getPermissionSchemeManager().getScheme(this.getPermissionSchemeId());
        }
        catch (GenericEntityException e) {
            return null;
        }
    }
}

