/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class AppProps
extends TagSupport {
    private String option;
    private String type;
    private String var;
    private static final List<String> ALLOWED_TYPES = ImmutableList.of((Object)"option", (Object)"string");

    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        this.validateInput();
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        if (this.getType().equals(ALLOWED_TYPES.get(0))) {
            boolean value = applicationProperties.getOption(this.getOption());
            this.getContext().setVariable(this.getVar(), (Object)value);
        } else if (this.getType().equals(ALLOWED_TYPES.get(1))) {
            String value = applicationProperties.getString(this.getOption());
            this.getContext().setVariable(this.getVar(), (Object)value);
        }
    }

    protected void validateInput() throws JellyTagException {
        if (!TextUtils.stringSet((String)this.getOption())) {
            throw new JellyTagException("The attribute 'option' mustr be set.");
        }
        if (!TextUtils.stringSet((String)this.getType())) {
            throw new JellyTagException("The attribute 'option' mustr be set.");
        }
        if (!ALLOWED_TYPES.contains(this.getType())) {
            throw new JellyTagException("The attribute 'type' must have one of the following values: " + ALLOWED_TYPES);
        }
        if (!TextUtils.stringSet((String)this.getVar())) {
            throw new JellyTagException("Attribute 'var' must be set");
        }
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

